/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.color;

import java.awt.Color;

public class ColorUtils {
    public Color[] interpolateColors(Color[] input, int colorCount) {
        Color[] colors = new Color[colorCount];
        int maxIndex = input.length - 1;
        float scale = (float)maxIndex / (float)(colorCount - 1);
        if (colorCount <= input.length) {
            return input;
        }
        for (int i = 0; i < colorCount; ++i) {
            float value = scale * (float)i;
            int index = (int)Math.floor(value);
            Color c1 = input[index];
            float remainder = 0.0f;
            Color c2 = null;
            if (index + 1 < input.length) {
                c2 = input[index + 1];
                remainder = value - (float)index;
            } else {
                c2 = input[index];
            }
            int red = Math.round((1.0f - remainder) * (float)c1.getRed() + remainder * (float)c2.getRed());
            int green = Math.round((1.0f - remainder) * (float)c1.getGreen() + remainder * (float)c2.getGreen());
            int blue = Math.round((1.0f - remainder) * (float)c1.getBlue() + remainder * (float)c2.getBlue());
            colors[i] = new Color(red, green, blue);
        }
        return colors;
    }
}

