/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.service.util.internal.utils;

import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyServiceListener<S>
extends ServiceTracker {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final BiConsumer<S, Map<String, String>> registerConsumer;
    private final BiConsumer<S, Map<String, String>> unregisterConsumer;
    private final Class<S> serviceClass;

    public CyServiceListener(BundleContext bc, Object target, String registerMethodName, String unregisterMethodName, Class<S> serviceClass, Class<?> methodClass, String additionalFilter) throws NoSuchMethodException {
        super(bc, CyServiceListener.genFilter(bc, serviceClass, additionalFilter), null);
        this.registerConsumer = new MethodRefectionConsumer<S>(target, registerMethodName, serviceClass, methodClass, true);
        this.unregisterConsumer = new MethodRefectionConsumer<S>(target, unregisterMethodName, serviceClass, methodClass, false);
        this.serviceClass = serviceClass;
    }

    public CyServiceListener(BundleContext bc, BiConsumer<S, Map<String, String>> registerConsumer, BiConsumer<S, Map<String, String>> unregisterConsumer, Class<S> serviceClass, String additionalFilter) {
        super(bc, CyServiceListener.genFilter(bc, serviceClass, additionalFilter), null);
        this.registerConsumer = Objects.requireNonNull(registerConsumer);
        this.unregisterConsumer = Objects.requireNonNull(unregisterConsumer);
        this.serviceClass = serviceClass;
    }

    private static Filter genFilter(BundleContext context, Class<?> serviceClass, String additionalFilter) {
        String filter = "(objectClass=" + serviceClass.getName() + ")";
        if (additionalFilter != null && !additionalFilter.isEmpty()) {
            filter = "(&" + filter + additionalFilter + ")";
        }
        try {
            return context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid filter syntax: " + filter, e);
            iae.initCause(e);
            throw iae;
        }
    }

    public Object addingService(ServiceReference ref) {
        Object service = super.addingService(ref);
        this.registerConsumer.accept(this.serviceClass.cast(service), this.getProperties(ref));
        return service;
    }

    public void removedService(ServiceReference ref, Object service) {
        super.removedService(ref, service);
        this.unregisterConsumer.accept(this.serviceClass.cast(service), this.getProperties(ref));
    }

    private Map<String, String> getProperties(ServiceReference ref) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        for (String key : ref.getPropertyKeys()) {
            props.put(key, ref.getProperty(key).toString());
        }
        return props;
    }

    private static class MethodRefectionConsumer<S>
    implements BiConsumer<S, Map<String, String>> {
        private final boolean register;
        private final Method method;
        private final Object target;
        private final Class<?> serviceClass;
        private final Class<?> methodClass;

        MethodRefectionConsumer(Object target, String methodName, Class<S> serviceClass, Class<?> methodClass, boolean register) throws NoSuchMethodException {
            this.target = target;
            this.serviceClass = serviceClass;
            this.methodClass = methodClass;
            this.method = this.getMethod(methodName);
            this.register = register;
        }

        @Override
        public void accept(S service, Map<String, String> properties) {
            try {
                this.method.invoke(this.target, this.serviceClass.cast(service), properties);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.warn("Failed to " + (this.register ? "register" : "unregister") + " service: ", (Throwable)e);
            }
        }

        private Method getMethod(String name) throws NoSuchMethodException {
            try {
                return this.target.getClass().getMethod(name, this.methodClass, Dictionary.class);
            }
            catch (NoSuchMethodException e) {
                return this.target.getClass().getMethod(name, this.methodClass, Map.class);
            }
        }
    }
}

