/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.service.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.cytoscape.service.util.internal.utils.CyServiceListener;
import org.cytoscape.service.util.internal.utils.ServiceUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCyActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<Class, Map<Object, ServiceRegistration>> serviceRegistrations = new HashMap<Class, Map<Object, ServiceRegistration>>();
    private final List<CyServiceListener> serviceListeners = new ArrayList<CyServiceListener>();
    private final List<ServiceReference<?>> gottenServices = new ArrayList();

    Map<Class, Map<Object, ServiceRegistration>> getServiceRegistrations() {
        return this.serviceRegistrations;
    }

    public final void stop(BundleContext bc) {
        this.shutDown();
        for (Map<Object, ServiceRegistration> map : this.serviceRegistrations.values()) {
            for (ServiceRegistration reg : map.values()) {
                reg.unregister();
            }
            map.clear();
        }
        this.serviceRegistrations.clear();
        for (CyServiceListener cyServiceListener : this.serviceListeners) {
            cyServiceListener.close();
        }
        this.serviceListeners.clear();
        for (ServiceReference serviceReference : this.gottenServices) {
            bc.ungetService(serviceReference);
        }
        this.gottenServices.clear();
    }

    public void shutDown() {
    }

    protected final <S> S getService(BundleContext bc, Class<S> serviceClass) {
        return ServiceUtil.getService(bc, serviceClass, this.gottenServices);
    }

    protected final <S> S getService(BundleContext bc, Class<S> serviceClass, String filter) {
        return ServiceUtil.getService(bc, serviceClass, filter, this.gottenServices);
    }

    protected final void registerServiceListener(BundleContext bc, Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass, Class<?> methodClass, String additionalFilter) {
        ServiceUtil.registerServiceListener(bc, listener, registerMethodName, unregisterMethodName, serviceClass, methodClass, additionalFilter, this.serviceListeners);
    }

    protected final void registerServiceListener(BundleContext bc, Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass) {
        this.registerServiceListener(bc, listener, registerMethodName, unregisterMethodName, serviceClass, serviceClass, null);
    }

    protected final void registerServiceListener(BundleContext bc, Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass, String additionalFilter) {
        this.registerServiceListener(bc, listener, registerMethodName, unregisterMethodName, serviceClass, serviceClass, additionalFilter);
    }

    protected <S> void registerServiceListener(BundleContext bc, BiConsumer<S, Map<String, String>> registerConsumer, BiConsumer<S, Map<String, String>> unregisterConsumer, Class<S> serviceClass) {
        ServiceUtil.registerServiceListener(bc, registerConsumer, unregisterConsumer, serviceClass, null, this.serviceListeners);
    }

    protected <S> void registerServiceListener(BundleContext bc, BiConsumer<S, Map<String, String>> registerConsumer, BiConsumer<S, Map<String, String>> unregisterConsumer, Class<S> serviceClass, String additionalFilter) {
        ServiceUtil.registerServiceListener(bc, registerConsumer, unregisterConsumer, serviceClass, additionalFilter, this.serviceListeners);
    }

    protected final void registerServiceListener(BundleContext bc, Object listener, String registerMethodName, String unregisterMethodName, Class<?> serviceClass, Class<?> methodClass) {
        this.registerServiceListener(bc, listener, registerMethodName, unregisterMethodName, serviceClass, methodClass, null);
    }

    protected final void registerAllServices(BundleContext bc, Object service, Properties props) {
        ServiceUtil.registerAllServices(bc, service, props, this.serviceRegistrations);
    }

    protected final void registerAllServices(BundleContext bc, Object service) {
        ServiceUtil.registerAllServices(bc, service, new Properties(), this.serviceRegistrations);
    }

    protected final void registerService(BundleContext bc, Object service, Class<?> serviceClass, Properties props) {
        ServiceUtil.registerService(bc, service, serviceClass, props, this.serviceRegistrations);
    }

    protected final void registerService(BundleContext bc, Object service, Class<?> serviceClass) {
        ServiceUtil.registerService(bc, service, serviceClass, new Properties(), this.serviceRegistrations);
    }
}

