/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model.events;

import java.util.Collection;
import org.cytoscape.event.AbstractCyEvent;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.SelectedNodesAndEdgesListener;

public class SelectedNodesAndEdgesEvent
extends AbstractCyEvent<CyNetwork> {
    private Collection<CyNode> selectedNodes;
    private Collection<CyNode> unselectedNodes;
    private Collection<CyEdge> selectedEdges;
    private Collection<CyEdge> unselectedEdges;
    private final boolean isCurrentNetwork;
    private final boolean nodesChanged;
    private final boolean edgesChanged;

    public SelectedNodesAndEdgesEvent(CyNetwork source, boolean isCurrentNetwork, boolean nodesChanged, boolean edgesChanged) {
        super(source, SelectedNodesAndEdgesListener.class);
        this.isCurrentNetwork = isCurrentNetwork;
        this.nodesChanged = nodesChanged;
        this.edgesChanged = edgesChanged;
    }

    public CyNetwork getNetwork() {
        return (CyNetwork)this.getSource();
    }

    public boolean isCurrentNetwork() {
        return this.isCurrentNetwork;
    }

    public boolean nodesChanged() {
        return this.nodesChanged;
    }

    public boolean edgesChanged() {
        return this.edgesChanged;
    }

    public Collection<CyNode> getSelectedNodes() {
        if (this.selectedNodes == null) {
            this.selectedNodes = CyTableUtil.getNodesInState(this.getNetwork(), "selected", true);
        }
        return this.selectedNodes;
    }

    public Collection<CyNode> getUnselectedNodes() {
        if (this.unselectedNodes == null) {
            this.unselectedNodes = CyTableUtil.getNodesInState(this.getNetwork(), "selected", false);
        }
        return this.unselectedNodes;
    }

    public Collection<CyEdge> getSelectedEdges() {
        if (this.selectedEdges == null) {
            this.selectedEdges = CyTableUtil.getEdgesInState(this.getNetwork(), "selected", true);
        }
        return this.selectedEdges;
    }

    public Collection<CyEdge> getUnselectedEdges() {
        if (this.unselectedEdges == null) {
            this.unselectedEdges = CyTableUtil.getEdgesInState(this.getNetwork(), "selected", false);
        }
        return this.unselectedEdges;
    }
}

