/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.model;

import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.VirtualColumnInfo;

public interface CyColumn
extends CyIdentifiable {
    public static final String NAMESPACE_SEPARATOR = "::";

    public static String[] splitColumnName(String fullyQualifiedName) {
        int index = fullyQualifiedName.indexOf(NAMESPACE_SEPARATOR);
        if (index == -1) {
            return new String[]{null, fullyQualifiedName};
        }
        String namespace = fullyQualifiedName.substring(0, index);
        String name = fullyQualifiedName.substring(index + NAMESPACE_SEPARATOR.length(), fullyQualifiedName.length());
        return new String[]{namespace, name};
    }

    public static String joinColumnName(String namespace, String name) {
        if (namespace == null) {
            return name;
        }
        return namespace + NAMESPACE_SEPARATOR + name;
    }

    public String getName();

    default public String getNamespace() {
        return CyColumn.splitColumnName(this.getName())[0];
    }

    default public String getNameOnly() {
        return CyColumn.splitColumnName(this.getName())[1];
    }

    public void setName(String var1);

    default public void setName(String namespace, String name) {
        this.setName(CyColumn.joinColumnName(namespace, name));
    }

    public Class<?> getType();

    public Class<?> getListElementType();

    public boolean isPrimaryKey();

    public boolean isImmutable();

    public CyTable getTable();

    public <T> List<T> getValues(Class<? extends T> var1);

    public VirtualColumnInfo getVirtualColumnInfo();

    public Object getDefaultValue();
}

