/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.cytoscape.io.webservice.WebServiceClient;

public abstract class AbstractWebServiceClient
implements WebServiceClient {
    private final URI serviceURI;
    private final String displayName;
    private final String description;

    public AbstractWebServiceClient(String uri, String displayName, String description) {
        try {
            this.serviceURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Given URI String is invalid: " + uri, e);
        }
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    public final String toString() {
        return this.displayName;
    }

    @Override
    public final URI getServiceLocation() {
        return this.serviceURI;
    }
}

