/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.read;

import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public abstract class AbstractCyNetworkReader
extends AbstractTask
implements CyNetworkReader {
    private static final String CREATE_NEW_COLLECTION_STRING = "-- Create new network collection --";
    private Map<String, CyRootNetwork> name2RootMap;
    private Map<Object, CyNode> nodeMap;
    private ListSingleSelection<String> rootNetworkList;
    private ListSingleSelection<String> targetColumnList;
    private ListSingleSelection<NetworkViewRenderer> rendererList;
    protected InputStream inputStream;
    protected CyNetwork[] networks;
    protected final CyNetworkViewFactory cyNetworkViewFactory;
    protected final CyNetworkFactory cyNetworkFactory;
    protected CyApplicationManager cyApplicationManager;
    private CyNetworkManager cyNetworkManager;
    private CyRootNetworkManager cyRootNetworkManager;

    @ProvidesTitle
    public String getTitle() {
        return "Import Network";
    }

    @Tunable(description="Network Collection:", groups={"_Network"}, gravity=1.0)
    public ListSingleSelection<String> getRootNetworkList() {
        return this.rootNetworkList;
    }

    public void setRootNetworkList(ListSingleSelection<String> roots) {
        this.rootNetworkList = roots;
        String rootNetName = this.rootNetworkList.getSelectedValue();
        if (rootNetName != null && !rootNetName.equalsIgnoreCase(CREATE_NEW_COLLECTION_STRING)) {
            this.setTargetColumnList(this.getTargetColumns(this.name2RootMap.get(rootNetName)));
        } else {
            this.setTargetColumnList(new ListSingleSelection<String>(new String[0]));
        }
    }

    @Tunable(description="Node Identifier Mapping Column:", groups={"_Network"}, gravity=2.0, listenForChange={"RootNetworkList"})
    public ListSingleSelection<String> getTargetColumnList() {
        return this.targetColumnList;
    }

    public void setTargetColumnList(ListSingleSelection<String> colList) {
        if (colList != this.targetColumnList) {
            this.targetColumnList = colList;
            if (this.targetColumnList.getPossibleValues().contains("shared name")) {
                this.targetColumnList.setSelectedValue("shared name");
            }
        }
    }

    @Tunable(description="Network View Renderer:", groups={"_Network"}, gravity=3.0)
    public ListSingleSelection<NetworkViewRenderer> getNetworkViewRendererList() {
        return this.rendererList;
    }

    public void setNetworkViewRendererList(ListSingleSelection<NetworkViewRenderer> rendererList) {
        this.rendererList = rendererList;
    }

    public AbstractCyNetworkReader(InputStream inputStream, CyApplicationManager cyApplicationManager, CyNetworkFactory cyNetworkFactory, CyNetworkManager cyNetworkManager, CyRootNetworkManager cyRootNetworkManager) {
        if (inputStream == null) {
            throw new NullPointerException("Input stream is null");
        }
        if (cyApplicationManager == null) {
            throw new NullPointerException("CyApplicationManager is null");
        }
        if (cyNetworkFactory == null) {
            throw new NullPointerException("CyNetworkFactory is null");
        }
        if (cyRootNetworkManager == null) {
            throw new NullPointerException("CyRootNetworkManager is null");
        }
        this.inputStream = inputStream;
        this.cyApplicationManager = cyApplicationManager;
        this.cyNetworkViewFactory = cyApplicationManager.getDefaultNetworkViewRenderer().getNetworkViewFactory();
        this.cyNetworkFactory = cyNetworkFactory;
        this.cyNetworkManager = cyNetworkManager;
        this.cyRootNetworkManager = cyRootNetworkManager;
        this.cyApplicationManager = cyApplicationManager;
        this.init();
    }

    public AbstractCyNetworkReader(InputStream inputStream, CyNetworkViewFactory cyNetworkViewFactory, CyNetworkFactory cyNetworkFactory, CyNetworkManager cyNetworkManager, CyRootNetworkManager cyRootNetworkManager) {
        if (inputStream == null) {
            throw new NullPointerException("Input stream is null");
        }
        if (cyNetworkViewFactory == null) {
            throw new NullPointerException("CyNetworkViewFactory is null");
        }
        if (cyNetworkFactory == null) {
            throw new NullPointerException("CyNetworkFactory is null");
        }
        if (cyRootNetworkManager == null) {
            throw new NullPointerException("CyRootNetworkManager is null");
        }
        this.inputStream = inputStream;
        this.cyNetworkViewFactory = cyNetworkViewFactory;
        this.cyNetworkFactory = cyNetworkFactory;
        this.cyNetworkManager = cyNetworkManager;
        this.cyRootNetworkManager = cyRootNetworkManager;
        this.init();
    }

    private void init() {
        String name;
        this.name2RootMap = this.getRootNetworkMap();
        this.nodeMap = new HashMap<Object, CyNode>(10000);
        ArrayList<String> rootNames = new ArrayList<String>();
        rootNames.addAll(this.name2RootMap.keySet());
        if (!rootNames.isEmpty()) {
            this.sort(rootNames);
            rootNames.add(0, CREATE_NEW_COLLECTION_STRING);
        }
        ListSingleSelection<String> rootNetList = new ListSingleSelection<String>((List<String>)rootNames);
        CyNetwork net = this.cyApplicationManager != null ? this.cyApplicationManager.getCurrentNetwork() : null;
        CyRootNetwork rootNet = net != null ? this.cyRootNetworkManager.getRootNetwork(net) : null;
        String string = name = rootNet != null ? rootNet.getRow(rootNet).get("name", String.class) : CREATE_NEW_COLLECTION_STRING;
        if (rootNames.contains(name)) {
            rootNetList.setSelectedValue(name);
        } else if (rootNames.contains(CREATE_NEW_COLLECTION_STRING)) {
            rootNetList.setSelectedValue(CREATE_NEW_COLLECTION_STRING);
        }
        this.setRootNetworkList(rootNetList);
        ArrayList<NetworkViewRenderer> renderers = new ArrayList<NetworkViewRenderer>();
        NetworkViewRenderer defViewRenderer = null;
        if (this.cyApplicationManager != null) {
            Set<NetworkViewRenderer> rendererSet = this.cyApplicationManager.getNetworkViewRendererSet();
            if (rendererSet.size() > 1) {
                renderers.addAll(rendererSet);
                Collections.sort(renderers, new Comparator<NetworkViewRenderer>(){

                    @Override
                    public int compare(NetworkViewRenderer r1, NetworkViewRenderer r2) {
                        return r1.toString().compareToIgnoreCase(r2.toString());
                    }
                });
            }
            defViewRenderer = this.cyApplicationManager.getDefaultNetworkViewRenderer();
        }
        this.rendererList = new ListSingleSelection(renderers);
        if (defViewRenderer != null && renderers.contains(defViewRenderer)) {
            this.rendererList.setSelectedValue(defViewRenderer);
        }
    }

    @Override
    public CyNetwork[] getNetworks() {
        return this.networks;
    }

    protected final CyRootNetwork getRootNetwork() {
        CyRootNetwork rootNetwork = null;
        String rootNetName = this.rootNetworkList.getSelectedValue();
        if (rootNetName != null) {
            rootNetwork = this.name2RootMap.get(rootNetName);
        }
        if (rootNetwork != null) {
            this.initNodeMap(rootNetwork);
        }
        return rootNetwork;
    }

    protected Map<Object, CyNode> getNodeMap() {
        return this.nodeMap;
    }

    protected CyNetworkViewFactory getNetworkViewFactory() {
        if (this.rendererList != null && this.rendererList.getSelectedValue() != null) {
            return this.rendererList.getSelectedValue().getNetworkViewFactory();
        }
        return this.cyNetworkViewFactory;
    }

    private final void initNodeMap(CyRootNetwork rootNetwork) {
        String rootNetName = this.rootNetworkList.getSelectedValue();
        if (rootNetName == null || rootNetName.equalsIgnoreCase(CREATE_NEW_COLLECTION_STRING)) {
            return;
        }
        String targetKeyColName = this.targetColumnList.getSelectedValue();
        if (targetKeyColName == null) {
            targetKeyColName = "shared name";
        }
        for (CyNode node : rootNetwork.getNodeList()) {
            Object keyValue = rootNetwork.getRow(node).getRaw(targetKeyColName);
            this.nodeMap.put(keyValue, node);
        }
    }

    private final ListSingleSelection<String> getTargetColumns(CyNetwork network) {
        CyTable selectedTable = network.getTable(CyNode.class, "SHARED_ATTRS");
        ArrayList<String> colNames = new ArrayList<String>();
        for (CyColumn col : selectedTable.getColumns()) {
            if (col.getName().equalsIgnoreCase("SUID") || col.getName().endsWith(".SUID") || col.getType() != String.class && col.getType() != Integer.class && col.getType() != Long.class) continue;
            colNames.add(col.getName());
        }
        if (colNames.isEmpty() || colNames.size() == 1 && colNames.contains("shared name")) {
            return new ListSingleSelection<String>(new String[0]);
        }
        this.sort(colNames);
        return new ListSingleSelection<String>((List<String>)colNames);
    }

    private final Map<String, CyRootNetwork> getRootNetworkMap() {
        HashMap<String, CyRootNetwork> name2RootMap = new HashMap<String, CyRootNetwork>();
        if (this.cyNetworkManager != null) {
            for (CyNetwork net : this.cyNetworkManager.getNetworkSet()) {
                CyRootNetwork rootNet = this.cyRootNetworkManager.getRootNetwork(net);
                if (name2RootMap.containsValue(rootNet)) continue;
                name2RootMap.put(rootNet.getRow(rootNet).get("name", String.class), rootNet);
            }
        }
        return name2RootMap;
    }

    private void sort(List<String> names) {
        if (!names.isEmpty()) {
            final Collator collator = Collator.getInstance(Locale.getDefault());
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    return collator.compare(s1, s2);
                }
            });
        }
    }
}

