/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCyFileFilter
implements CyFileFilter {
    protected final Set<String> extensions;
    protected final Set<String> contentTypes;
    protected final String description;
    protected final StreamUtil streamUtil;
    protected final DataCategory category;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public BasicCyFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        this.extensions = BasicCyFileFilter.cleanStringSet(extensions);
        this.contentTypes = contentTypes;
        this.category = category;
        StringBuilder builder = new StringBuilder();
        builder.append((String)(description == null ? "(" : description + " ("));
        for (String ex : this.extensions) {
            builder.append("*." + ex + ", ");
        }
        Object d = builder.toString();
        d = ((String)d).substring(0, ((String)d).length() - 2);
        this.description = d = (String)d + ")";
        this.streamUtil = streamUtil;
    }

    public BasicCyFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        this(new HashSet<String>(Arrays.asList(extensions)), new HashSet<String>(Arrays.asList(contentTypes)), description, category, streamUtil);
    }

    private static final SortedSet<String> cleanStringSet(Set<String> strings) {
        TreeSet<String> cleanedStrings = new TreeSet<String>();
        if (strings != null) {
            for (String string : strings) {
                if (string == null) continue;
                cleanedStrings.add(string.trim().toLowerCase());
            }
        }
        return cleanedStrings;
    }

    @Override
    public boolean accepts(URI uri, DataCategory category) {
        if (category != this.category) {
            return false;
        }
        return this.extensionsMatch(uri);
    }

    private boolean extensionsMatch(URI uri) {
        String extension = this.getExtension(uri.toString());
        return this.extensions.contains(extension);
    }

    @Override
    public boolean accepts(InputStream stream, DataCategory category) {
        return false;
    }

    @Override
    public final Set<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public final Set<String> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final DataCategory getDataCategory() {
        return this.category;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.description + " [category: " + this.category + "]  [extensions: ");
        for (String ext : this.extensions) {
            builder.append(ext + ",");
        }
        Object s = builder.toString();
        s = (String)s + "]   [contentTypes: ";
        for (String c : this.contentTypes) {
            s = (String)s + c + ",";
        }
        s = (String)s + "]";
        return s;
    }

    protected final String getExtension(String filename) {
        return CommonsIOFilenameUtils.getExtension(filename).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getHeader(InputStream stream, int numLines) {
        String header;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        try {
            header = this.parseHeader(br, numLines);
        }
        catch (IOException ioe) {
            logger.warn("failed to read header from stream", (Throwable)ioe);
            header = "";
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            br = null;
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String parseHeader(BufferedReader bufferedReader, int numLines) throws IOException {
        StringBuilder header = new StringBuilder();
        try {
            String line = bufferedReader.readLine();
            for (int lineCount = 0; line != null && lineCount < numLines; ++lineCount) {
                header.append(line + "\n");
                line = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return header.toString();
    }

    private static class CommonsIOFilenameUtils {
        public static final char EXTENSION_SEPARATOR = '.';
        private static final char UNIX_SEPARATOR = '/';
        private static final char WINDOWS_SEPARATOR = '\\';

        private CommonsIOFilenameUtils() {
        }

        public static String getExtension(String filename) {
            if (filename == null) {
                return null;
            }
            int index = CommonsIOFilenameUtils.indexOfExtension(filename);
            if (index == -1) {
                return "";
            }
            return filename.substring(index + 1);
        }

        public static int indexOfExtension(String filename) {
            if (filename == null) {
                return -1;
            }
            int extensionPos = filename.lastIndexOf(46);
            int lastSeparator = CommonsIOFilenameUtils.indexOfLastSeparator(filename);
            return lastSeparator > extensionPos ? -1 : extensionPos;
        }

        public static int indexOfLastSeparator(String filename) {
            if (filename == null) {
                return -1;
            }
            int lastUnixPos = filename.lastIndexOf(47);
            int lastWindowsPos = filename.lastIndexOf(92);
            return Math.max(lastUnixPos, lastWindowsPos);
        }
    }
}

