/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public final class Equation {
    private final String equation;
    private final Set<String> variableReferences;
    private final Map<String, Object> defaultVariableValues;
    private final Object[] code;
    private final int[] sourceLocations;
    private final Class<?> type;

    public Equation(String equation, Set<String> variableReferences, Map<String, Object> defaultVariableValues, Object[] code, int[] sourceLocations, Class<?> type) {
        this.equation = equation;
        this.variableReferences = variableReferences;
        this.defaultVariableValues = defaultVariableValues;
        this.code = Arrays.copyOf(code, code.length);
        this.sourceLocations = Arrays.copyOf(sourceLocations, sourceLocations.length);
        this.type = type;
    }

    public String toString() {
        return this.equation;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Equation.class) {
            return false;
        }
        Equation otherEquation = (Equation)other;
        return this.equation.equals(otherEquation.equation);
    }

    public int hashCode() {
        return this.equation.hashCode();
    }

    public Set<String> getVariableReferences() {
        return this.variableReferences;
    }

    public Map<String, Object> getDefaultVariableValues() {
        return this.defaultVariableValues;
    }

    public Object[] getCode() {
        return this.code;
    }

    public int[] getSourceLocations() {
        return this.sourceLocations;
    }

    public Class<?> getType() {
        return this.type;
    }
}

