/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.List;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public final class ArgDescriptor {
    private final ArgType argType;
    private final String argName;
    private final String description;

    public ArgDescriptor(ArgType argType, String argName, String description) {
        this.argType = argType;
        this.argName = argName;
        this.description = description;
    }

    public ArgType getArgType() {
        return this.argType;
    }

    public String getArgName() {
        return this.argName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOptional() {
        return this.argType.isOptional();
    }

    public boolean isCompatibleWith(Class type) {
        for (Class compatibleType : this.argType.getCompatibleTypes()) {
            if (type == compatibleType) {
                return true;
            }
            if (!List.class.equals((Object)compatibleType) || !List.class.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatibleList(Class listElementType) {
        if (listElementType != null) {
            for (Class compatibleType : this.argType.getCompatibleTypes()) {
                if (compatibleType != listElementType) continue;
                return true;
            }
            return false;
        }
        for (Class compatibleType : this.argType.getCompatibleTypes()) {
            if (!FunctionUtil.isTypeOfList(compatibleType)) continue;
            return true;
        }
        return false;
    }

    public Class[] getCompatibleTypes() {
        return this.argType.getCompatibleTypes();
    }

    public boolean acceptsMultipleArgs() {
        return this.argType.acceptsMultipleArgs();
    }
}

