/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.application.swing.search;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.cytoscape.application.swing.search.NetworkSearchTaskFactory;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.TaskObserver;

public abstract class AbstractNetworkSearchTaskFactory
extends AbstractTaskFactory
implements NetworkSearchTaskFactory {
    private String query;
    private final String id;
    private final String name;
    private final String description;
    private final Icon icon;
    private final URL website;

    protected AbstractNetworkSearchTaskFactory(String id, String name, Icon icon) {
        this(id, name, null, icon, null);
    }

    protected AbstractNetworkSearchTaskFactory(String id, String name, String description, Icon icon) {
        this(id, name, description, icon, null);
    }

    protected AbstractNetworkSearchTaskFactory(String id, String name, String description, Icon icon, URL website) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("'id' must not be null or blank.");
        }
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("'name' must not be null or blank.");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.website = website;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public URL getWebsite() {
        return this.website;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public TaskObserver getTaskObserver() {
        return null;
    }

    @Override
    public JComponent getQueryComponent() {
        return null;
    }

    @Override
    public JComponent getOptionsComponent() {
        return null;
    }

    @Override
    public boolean isReady() {
        String s = this.getQuery();
        return s != null && !s.trim().isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 11;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNetworkSearchTaskFactory other = (AbstractNetworkSearchTaskFactory)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.name;
    }
}

