/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diagnostics.internal.heuristics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.diagnostics.internal.heuristics.AbstractHeuristic;

public abstract class ProcHeuristic<T>
extends AbstractHeuristic<T> {
    static final Pattern CPUINFO_MODEL_NAME_PATTERN = Pattern.compile("model name\\s*[:]\\s+(.*)\\s*");
    static final Pattern MEMINFO_MEMTOTAL_PATTERN = Pattern.compile("MemTotal:\\s+(.*)\\s*");
    static final Pattern MEMINFO_MEMFREE_PATTERN = Pattern.compile("MemFree:\\s+(.*)\\s*");
    static final Pattern MEMINFO_SWAPTOTAL_PATTERN = Pattern.compile("SwapTotal:\\s+(.*)\\s*");
    static final Pattern MEMINFO_SWAPFREE_PATTERN = Pattern.compile("SwapFree:\\s+(.*)\\s*");

    protected Long parseMemTotal(String value) {
        if (value == null) {
            return null;
        }
        String[] values = value.split(" ");
        long baseValue = Long.parseLong(values[0]);
        if (values.length > 1 && "kB".equals(values[1])) {
            baseValue *= 1024L;
        }
        return baseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <S> S getValueFromProc(String fileName, Pattern pattern, Class<S> type) throws IOException {
        File file = new File("/proc/" + fileName);
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    S s = this.convert(matcher.group(1), type);
                    return s;
                }
                line = reader.readLine();
            }
            S s = null;
            return s;
        }
    }

    public static class FreeSwap
    extends ProcHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemTotal(this.getValueFromProc("meminfo", MEMINFO_SWAPFREE_PATTERN, String.class));
        }
    }

    public static class TotalSwap
    extends ProcHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemTotal(this.getValueFromProc("meminfo", MEMINFO_SWAPTOTAL_PATTERN, String.class));
        }
    }

    public static class ProcessorName
    extends ProcHeuristic<String> {
        @Override
        public String computeValue() throws IOException {
            return this.getValueFromProc("cpuinfo", CPUINFO_MODEL_NAME_PATTERN, String.class);
        }
    }

    public static class FreeMemory
    extends ProcHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemTotal(this.getValueFromProc("meminfo", MEMINFO_MEMFREE_PATTERN, String.class));
        }
    }

    public static class TotalMemory
    extends ProcHeuristic<Long> {
        @Override
        public Long computeValue() throws IOException {
            return this.parseMemTotal(this.getValueFromProc("meminfo", MEMINFO_MEMTOTAL_PATTERN, String.class));
        }
    }
}

