/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.diffusion.internal.task.EmptyTaskMonitor;
import org.cytoscape.diffusion.internal.util.DiffusionTableManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.task.create.NewNetworkSelectedNodesOnlyTaskFactory;
import org.cytoscape.task.read.LoadVizmapFileTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class SubnetCreatorPanel
extends JPanel {
    private static final long serialVersionUID = 7578596629235573519L;
    private static final String STYLES = "/styles.xml";
    private final NewNetworkSelectedNodesOnlyTaskFactory createSubnetworkFactory;
    private final DiffusionTableManager tableManager;
    private JComboBox<String> styleComboBox;
    private final LoadVizmapFileTaskFactory vizmapLoader;
    private Set<VisualStyle> visualStyles = null;
    private final VisualMappingManager vmm;
    private final CyApplicationManager appManager;
    final RenderingEngineManager renderingEngineMgr;

    SubnetCreatorPanel(DiffusionTableManager tableManager, LoadVizmapFileTaskFactory vizmapLoader, VisualMappingManager vmm, NewNetworkSelectedNodesOnlyTaskFactory createSubnetworkFactory, CyApplicationManager appManager, RenderingEngineManager renderingEngineMgr) {
        this.createSubnetworkFactory = createSubnetworkFactory;
        this.tableManager = tableManager;
        this.vizmapLoader = vizmapLoader;
        this.vmm = vmm;
        this.appManager = appManager;
        this.renderingEngineMgr = renderingEngineMgr;
        this.setLayout(new BorderLayout());
        this.setMaximumSize(new Dimension(1000, 100));
        this.setBorder(BorderFactory.createTitledBorder("Create subnetwork from selected nodes"));
        JLabel styleLabel = new JLabel("Visual Style: ");
        this.styleComboBox = new JComboBox();
        this.styleComboBox.setToolTipText("Selected Visual Style will be applied to the new subnetwork.");
        JButton makeSubnetButton = new JButton("Create");
        makeSubnetButton.setMaximumSize(new Dimension(100, 40));
        makeSubnetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubnetCreatorPanel.this.createSubnetwork();
            }
        });
        this.add((Component)styleLabel, "Before");
        this.add(this.styleComboBox, "Center");
        this.add((Component)makeSubnetButton, "After");
    }

    protected void updateStyles() {
        if (this.visualStyles == null) {
            VisualStyle defStyle = this.vmm.getDefaultVisualStyle();
            try {
                this.visualStyles = this.vizmapLoader.loadStyles(this.getClass().getResource(STYLES).openStream());
                this.visualStyles.add(defStyle);
                List styleNames = this.visualStyles.stream().map(style -> style.getTitle()).collect(Collectors.toList());
                this.styleComboBox.setModel(new DefaultComboBoxModel<Object>(styleNames.toArray()));
                this.styleComboBox.setSelectedItem(defStyle.getTitle());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private final void createSubnetwork() {
        VisualStyle style = this.getSelectedStyle();
        CyNetwork network = this.tableManager.getCurrentTable().getAssociatedNetwork();
        if (network.getDefaultNodeTable().getMatchingRows("selected", (Object)true).isEmpty()) {
            return;
        }
        CyNetworkView view = this.createSubnet(network);
        if (view == null) {
            return;
        }
        this.appManager.setCurrentNetwork((CyNetwork)view.getModel());
        this.vmm.setVisualStyle(style, view);
        this.vmm.setCurrentVisualStyle(style);
        style.apply(view);
        view.fitContent();
        view.updateView();
    }

    private final VisualStyle getSelectedStyle() {
        for (VisualStyle style : this.visualStyles) {
            if (!style.getTitle().equals(this.styleComboBox.getSelectedItem())) continue;
            return style;
        }
        return null;
    }

    public CyNetworkView createSubnet(CyNetwork network) {
        TaskIterator taskIterator = this.createSubnetworkFactory.createTaskIterator(network);
        boolean viewCopied = false;
        ObservableTask viewTask = null;
        try {
            while (!viewCopied || taskIterator.hasNext()) {
                if (!taskIterator.hasNext()) continue;
                Task task = taskIterator.next();
                task.run((TaskMonitor)new EmptyTaskMonitor());
                if (task.getClass().getName().endsWith("CopyExistingViewTask")) {
                    viewCopied = true;
                    continue;
                }
                if (!task.getClass().getName().endsWith("RegisterNetworkTask")) continue;
                viewTask = (ObservableTask)task;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (viewTask == null) {
            return null;
        }
        CyNetworkView result = (CyNetworkView)viewTask.getResults(CyNetworkView.class);
        return result;
    }
}

