/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.ui;

import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cytoscape.diffusion.internal.ui.AbstractSliderPanel;
import org.cytoscape.diffusion.internal.util.DiffusionTable;

public class HeatSelectionPanel
extends AbstractSliderPanel {
    private static final int MIN = 0;
    private static final int MAX = 1000;

    HeatSelectionPanel(DiffusionTable diffusionTable, String title) {
        super(diffusionTable, title, "", " Threshold");
    }

    protected void setThreshold(Double threshold) {
        this.selectNodesOverThreshold(this.diffusionTable.getCurrentResult().getHeatColumnName(), threshold);
    }

    @Override
    protected JSlider createSlider() {
        final JSlider slider = new JSlider(0, 1000);
        slider.setOpaque(false);
        String maxHeat = String.format("%.2f", this.diffusionTable.getCurrentResult().getMaxHeat());
        String minHeat = String.format("%.2f", this.diffusionTable.getCurrentResult().getMinHeat());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("Cold (" + minHeat + ")"));
        labelTable.put(1000, new JLabel("Hot (" + maxHeat + ")"));
        slider.setLabelTable(labelTable);
        slider.setPaintLabels(true);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!slider.getValueIsAdjusting()) {
                    int newVal = slider.getValue();
                    Double threshold = HeatSelectionPanel.this.diffusionTable.getCurrentResult().getMaxHeat() / 1000.0 * (double)newVal;
                    HeatSelectionPanel.this.setThreshold(threshold);
                    HeatSelectionPanel.this.valuePanel.setValue(threshold);
                }
            }
        });
        Integer ninteithPercentile = 900;
        Double threshold = this.diffusionTable.getCurrentResult().getMaxHeat() / 1000.0 * (double)ninteithPercentile.intValue();
        this.setThreshold(threshold);
        this.valuePanel.setValue(threshold);
        slider.setValue(ninteithPercentile);
        slider.setInverted(true);
        return slider;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("VALUE_SET")) {
            return;
        }
        Double original = (Double)evt.getNewValue();
        Double value = 1000.0 * original / this.diffusionTable.getCurrentResult().getMaxHeat();
        if (0.0 <= value && 1000.0 >= value) {
            this.thresholdSlider.setValue(value.intValue());
        } else if (1000.0 < value) {
            this.thresholdSlider.setValue(1000);
        } else {
            this.thresholdSlider.setValue(0);
        }
    }
}

