/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIExceptionFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.diffusion.internal.client.DiffusionServiceException;
import org.cytoscape.diffusion.internal.rest.DiffusionParameters;
import org.cytoscape.diffusion.internal.rest.DiffusionResultColumns;
import org.cytoscape.diffusion.internal.rest.DiffusionTaskObserver;
import org.cytoscape.diffusion.internal.rest.RemoteLogger;
import org.cytoscape.diffusion.internal.task.DiffusionContextMenuTaskFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.util.ListSingleSelection;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Apps: Diffusion"})
@Path(value="/diffusion/v1/")
public class DiffusionResource {
    private final CyApplicationManager cyApplicationManager;
    private final SynchronousTaskManager<Object> taskManager;
    private final CyNetworkManager cyNetworkManager;
    private final CyNetworkViewManager cyNetworkViewManager;
    private final DiffusionContextMenuTaskFactory diffusionTaskFactory;
    private final DiffusionContextMenuTaskFactory diffusionWithOptionsTaskFactory;
    private final ServiceTracker ciResponseFactoryTracker;
    private final ServiceTracker ciExceptionFactoryTracker;
    private final ServiceTracker ciErrorFactoryTracker;
    public static final String POST = "POST";
    public static final String CY_NETWORK_NOT_FOUND_CODE = "1";
    public static final String CY_NETWORK_VIEW_NOT_FOUND_CODE = "2";
    public static final String TASK_EXECUTION_ERROR_CODE = "3";
    private static final Logger logger = LoggerFactory.getLogger(DiffusionResource.class);
    private static final RemoteLogger remoteLogger = RemoteLogger.getDefaultLogger();
    private static final String resourceErrorRoot = "urn:cytoscape:ci:diffusion-app:v1";

    private CIResponseFactory getCIResponseFactory() {
        return (CIResponseFactory)this.ciResponseFactoryTracker.getService();
    }

    private CIExceptionFactory getCIExceptionFactory() {
        return (CIExceptionFactory)this.ciExceptionFactoryTracker.getService();
    }

    private CIErrorFactory getCIErrorFactory() {
        return (CIErrorFactory)this.ciErrorFactoryTracker.getService();
    }

    public DiffusionResource(CyApplicationManager cyApplicationManager, SynchronousTaskManager<Object> taskManager, CyNetworkManager cyNetworkManager, CyNetworkViewManager cyNetworkViewManager, DiffusionContextMenuTaskFactory diffusionTaskFactory, DiffusionContextMenuTaskFactory diffusionWithOptionsTaskFactory, ServiceTracker ciResponseFactoryTracker, ServiceTracker ciExceptionFactoryTracker, ServiceTracker ciErrorFactoryTracker) {
        this.cyApplicationManager = cyApplicationManager;
        this.taskManager = taskManager;
        this.cyNetworkManager = cyNetworkManager;
        this.cyNetworkViewManager = cyNetworkViewManager;
        this.diffusionTaskFactory = diffusionTaskFactory;
        this.diffusionWithOptionsTaskFactory = diffusionWithOptionsTaskFactory;
        this.ciResponseFactoryTracker = ciResponseFactoryTracker;
        this.ciExceptionFactoryTracker = ciExceptionFactoryTracker;
        this.ciErrorFactoryTracker = ciErrorFactoryTracker;
    }

    private CIError buildCIError(int status, String resourcePath, String code, String message, Exception e) {
        String errorUrn = "urn:cytoscape:ci:diffusion-app:v1:" + resourcePath + ":" + code;
        remoteLogger.logResourceError(POST, resourcePath, status, errorUrn);
        return this.getCIErrorFactory().getCIError(Integer.valueOf(status), "urn:cytoscape:ci:diffusion-app:v1:" + resourcePath + ":" + code, message);
    }

    CIResponse<Object> buildCIErrorResponse(int status, String resourcePath, String code, String message, Exception e) {
        CIResponse response = this.getCIResponseFactory().getCIResponse(new Object());
        CIError error = this.buildCIError(status, resourcePath, code, message, e);
        if (e != null) {
            logger.error(message, (Throwable)e);
            if (e instanceof DiffusionServiceException) {
                response.errors.addAll(((DiffusionServiceException)e).getCIErrors());
            }
        } else {
            logger.error(message);
        }
        response.errors.add(error);
        return response;
    }

    public CyNetwork getCyNetwork(String resourcePath, String errorType) {
        CyNetwork cyNetwork = this.cyApplicationManager.getCurrentNetwork();
        if (cyNetwork == null) {
            String messageString = "Could not find current Network";
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, resourcePath, errorType, messageString, null)});
        }
        return cyNetwork;
    }

    public CyNetworkView getCyNetworkView(String resourcePath, String errorType) {
        CyNetworkView cyNetworkView = this.cyApplicationManager.getCurrentNetworkView();
        if (cyNetworkView == null) {
            String messageString = "Could not find current Network View";
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, resourcePath, errorType, messageString, null)});
        }
        return cyNetworkView;
    }

    public CyNetworkView getCyNetworkView(String resourcePath, String errorType, long networkSUID, long networkViewSUID) {
        CyNetwork network = this.cyNetworkManager.getNetwork(networkSUID);
        if (network == null) {
            String messageString = "Could not find network with SUID: " + networkSUID;
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, resourcePath, errorType, messageString, null)});
        }
        Collection views = this.cyNetworkViewManager.getNetworkViews(network);
        if (views.isEmpty()) {
            String messageString = "No views are available for network with SUID: " + networkSUID;
            throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, resourcePath, errorType, messageString, null)});
        }
        for (CyNetworkView view : views) {
            Long vid = view.getSUID();
            if (!vid.equals(networkViewSUID)) continue;
            return view;
        }
        String messageString = "Could not find network view with SUID: " + networkViewSUID + " for network with SUID: " + networkSUID;
        throw this.getCIExceptionFactory().getCIException(404, new CIError[]{this.buildCIError(404, resourcePath, errorType, messageString, null)});
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="currentView/diffuse_with_options")
    @ApiOperation(value="Execute Diffusion Analysis on Current View with Options", notes="Diffusion will send the selected network view and its selected nodes to a web-based REST service to calculate network propagation. Results are returned and represented by columns in the node table.\n\nColumns are created for each execution of Diffusion and their names are returned in the response.\n\n", response=DiffusionAppResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network or Network View does not exist", response=CIResponse.class)})
    public Response diffuseWithOptions(@ApiParam(value="Diffusion Parameters", required=true) DiffusionParameters diffusionParameters) {
        CyNetwork cyNetwork = this.getCyNetwork("diffuse_current_view_with_options", CY_NETWORK_NOT_FOUND_CODE);
        CyNetworkView cyNetworkView = this.getCyNetworkView("diffuse_current_view_with_options", CY_NETWORK_VIEW_NOT_FOUND_CODE);
        Response response = this.diffuseWithOptions(cyNetwork.getSUID(), cyNetworkView.getSUID(), diffusionParameters);
        remoteLogger.logResourceResponse(POST, "/diffusion/v1/currentView/diffuse_with_options", response.getStatus());
        return response;
    }

    private void logCIResponse(String httpMethod, String path, CIResponse<?> response) {
        try {
            if (response.errors.size() == 0) {
                remoteLogger.logResourceResponse(httpMethod, path, Response.Status.OK.getStatusCode());
            } else {
                for (CIError error : response.errors) {
                    remoteLogger.logResourceError(httpMethod, path, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), error.type);
                }
            }
        }
        catch (Throwable e) {
            logger.error("Remote logging response parse failed", e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{networkSUID}/views/{networkViewSUID}/diffuse_with_options")
    @ApiOperation(value="Execute Diffusion Analysis on a Specific Network View with Options", notes="Diffusion will send the selected network view and its selected nodes to a web-based REST service to calculate network propagation. Results are returned and represented by columns in the node table.\n\nColumns are created for each execution of Diffusion and their names are returned in the response.\n\n", response=DiffusionAppResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CIResponse.class)})
    public Response diffuseWithOptions(@ApiParam(value="Network SUID (see GET /v1/networks)") @PathParam(value="networkSUID") long networkSUID, @ApiParam(value="Network View SUID (see GET /v1/networks/{networkId}/views)") @PathParam(value="networkViewSUID") long networkViewSUID, @ApiParam(value="Diffusion Parameters", required=true) DiffusionParameters diffusionParameters) {
        CyNetworkView cyNetworkView = this.getCyNetworkView("diffuse_with_options", CY_NETWORK_VIEW_NOT_FOUND_CODE, networkSUID, networkViewSUID);
        DiffusionTaskObserver taskObserver = new DiffusionTaskObserver(this, "diffuse_with_options", TASK_EXECUTION_ERROR_CODE);
        HashMap<String, Object> tunableMap = new HashMap<String, Object>();
        ListSingleSelection heatColumnName = new ListSingleSelection((Object[])new String[0]);
        ArrayList<String> heatColumns = new ArrayList<String>();
        heatColumns.add(diffusionParameters.heatColumnName);
        heatColumnName.setPossibleValues(heatColumns);
        heatColumnName.setSelectedValue((Object)diffusionParameters.heatColumnName);
        tunableMap.put("heatColumnName", heatColumnName);
        tunableMap.put("time", diffusionParameters.time);
        TaskIterator taskIterator = this.diffusionWithOptionsTaskFactory.createTaskIterator(cyNetworkView);
        this.taskManager.setExecutionContext(tunableMap);
        this.taskManager.execute(taskIterator, (TaskObserver)taskObserver);
        this.logCIResponse(POST, "/diffusion/v1/{networkSUID}/views/{networkViewSUID}/diffuse_with_options", taskObserver.response);
        return Response.status((Response.Status)(taskObserver.response.errors.size() == 0 ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR)).type("application/json").entity(taskObserver.response).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="currentView/diffuse")
    @ApiOperation(value="Execute Diffusion Analysis on Current View", notes="Diffusion will send the selected network view and its selected nodes to a web-based REST service to calculate network propagation. Results are returned and represented by columns in the node table.\n\nColumns are created for each execution of Diffusion and their names are returned in the response.\n\nThe nodes you would like to use as input should be selected. This will be used to generate the contents of the **diffusion\\_input** column, which represents the query vector and corresponds to h in the diffusion equation.\n\n", response=DiffusionAppResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network or Network View does not exist", response=CIResponse.class)})
    public Response diffuse() {
        CyNetwork cyNetwork = this.getCyNetwork("diffuse_current_view", CY_NETWORK_NOT_FOUND_CODE);
        CyNetworkView cyNetworkView = this.getCyNetworkView("diffuse_current_view", CY_NETWORK_VIEW_NOT_FOUND_CODE);
        Response response = this.diffuse(cyNetwork.getSUID(), cyNetworkView.getSUID());
        remoteLogger.logResourceResponse(POST, "/diffusion/v1/currentView/diffuse", response.getStatus());
        return response;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="{networkSUID}/views/{networkViewSUID}/diffuse")
    @ApiOperation(value="Execute Diffusion Analysis on a Specific Network View", notes="Diffusion will send the selected network view and its selected nodes to a web-based REST service to calculate network propagation. Results are returned and represented by columns in the node table.\n\nColumns are created for each execution of Diffusion and their names are returned in the response.\n\nThe nodes you would like to use as input should be selected. This will be used to generate the contents of the **diffusion\\_input** column, which represents the query vector and corresponds to h in the diffusion equation.\n\n", response=DiffusionAppResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CIResponse.class)})
    public Response diffuse(@ApiParam(value="Network SUID (see GET /v1/networks)") @PathParam(value="networkSUID") long networkSUID, @ApiParam(value="Network View SUID (see GET /v1/networks/{networkId}/views)") @PathParam(value="networkViewSUID") long networkViewSUID) {
        System.out.println("Accessing Diffusion via REST");
        DiffusionTaskObserver taskObserver = new DiffusionTaskObserver(this, "diffuse", TASK_EXECUTION_ERROR_CODE);
        this.executeDiffuse(networkSUID, networkViewSUID, taskObserver);
        this.logCIResponse(POST, "/diffusion/v1/{networkSUID}/views/{networkViewSUID}/diffuse", taskObserver.response);
        return Response.status((Response.Status)(taskObserver.response.errors.size() == 0 ? Response.Status.OK : Response.Status.INTERNAL_SERVER_ERROR)).type("application/json").entity(taskObserver.response).build();
    }

    public void executeDiffuse(long networkSUID, long networkViewSUID, TaskObserver taskObserver) {
        CyNetworkView cyNetworkView = this.getCyNetworkView("diffuse", CY_NETWORK_VIEW_NOT_FOUND_CODE, networkSUID, networkViewSUID);
        TaskIterator taskIterator = this.diffusionTaskFactory.createTaskIterator(cyNetworkView);
        this.taskManager.execute(taskIterator, taskObserver);
    }

    @ApiModel(value="Diffusion App Response", description="Diffusion Analysis Results in CI Format", parent=CIResponse.class)
    public static class DiffusionAppResponse
    extends CIResponse<DiffusionResultColumns> {
    }
}

