/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.cycl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cytoscape.opencl.cycl.CyCL;
import org.cytoscape.opencl.cycl.CyCLDevice;
import org.cytoscape.property.CyProperty;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.util.ListSingleSelection;

public class CyCLSettingsTask
extends AbstractTask
implements TunableValidator {
    static final String OPENCL_PREFERREDNAME = "opencl.device.preferred";
    private static final List<String> KEYS = Arrays.asList("opencl.device.preferred");
    private static final List<String> DEVICE_NAMES = new ArrayList<String>();
    @Tunable(description="Preferred Device:")
    public ListSingleSelection<String> preferredNameList;
    private final Map<String, String> oldSettings = new HashMap<String, String>();
    private final Properties properties;

    @ProvidesTitle
    public String getTitle() {
        return "OpenCL Settings";
    }

    public CyCLSettingsTask(CyProperty<Properties> properties) {
        this.properties = (Properties)properties.getProperties();
        DEVICE_NAMES.clear();
        List<CyCLDevice> devices = CyCL.getDevices();
        for (CyCLDevice device : devices) {
            DEVICE_NAMES.add(device.name);
        }
        this.preferredNameList = new ListSingleSelection(DEVICE_NAMES);
        try {
            String preferredName = this.properties.getProperty(OPENCL_PREFERREDNAME);
            if (DEVICE_NAMES.contains(preferredName)) {
                this.preferredNameList.setSelectedValue((Object)preferredName);
            } else {
                this.preferredNameList.setSelectedValue((Object)DEVICE_NAMES.get(0));
            }
        }
        catch (IllegalArgumentException e) {
            this.preferredNameList.setSelectedValue((Object)DEVICE_NAMES.get(0));
        }
        this.assignSystemProperties();
    }

    public void assignSystemProperties() {
        String newPreferred = this.properties.getProperty(OPENCL_PREFERREDNAME);
        if (newPreferred == null || newPreferred.length() == 0) {
            return;
        }
        CyCL.makePreferred(newPreferred);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        this.storeSettings();
        this.revertSettings();
        return TunableValidator.ValidationState.OK;
    }

    public void run(TaskMonitor taskMonitor) {
        taskMonitor.setProgress(0.0);
        this.storeSettings();
        this.oldSettings.clear();
        taskMonitor.setProgress(1.0);
    }

    void storeSettings() {
        this.oldSettings.clear();
        for (String key : KEYS) {
            if (this.properties.getProperty(key) != null) {
                this.oldSettings.put(key, this.properties.getProperty(key));
            }
            this.properties.remove(key);
        }
        this.properties.setProperty(OPENCL_PREFERREDNAME, (String)this.preferredNameList.getSelectedValue());
        this.assignSystemProperties();
    }

    void revertSettings() {
        for (String key : KEYS) {
            this.properties.remove(key);
            if (!this.oldSettings.containsKey(key)) continue;
            this.properties.setProperty(key, this.oldSettings.get(key));
        }
        this.oldSettings.clear();
        this.assignSystemProperties();
    }
}

