/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.cycl;

import java.nio.IntBuffer;
import org.cytoscape.opencl.cycl.CyCL;
import org.cytoscape.opencl.cycl.CyCLBuffer;
import org.cytoscape.opencl.cycl.CyCLContext;
import org.cytoscape.opencl.cycl.CyCLException;
import org.cytoscape.opencl.cycl.CyCLLocalSize;
import org.cytoscape.opencl.cycl.CyCLProgram;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.Util;

public class CyCLKernel {
    private Boolean finalized = false;
    private CLKernel kernel;
    private CyCLContext context;

    public CyCLKernel(CyCLContext context, CyCLProgram program, String kernelName) {
        this.context = context;
        IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
        this.kernel = CL10.clCreateKernel((CLProgram)program.getProgram(), (CharSequence)kernelName, (IntBuffer)errorBuffer);
        Util.checkCLError((int)errorBuffer.get(0));
    }

    public void execute(long[] dimsGlobal, long[] dimsLocal, Object ... args) {
        this.executeWithOffset(dimsGlobal, dimsLocal, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithOffset(long[] dimsGlobal, long[] dimsLocal, long[] globalOffset, Object ... args) {
        Object object = CyCL.sync;
        synchronized (object) {
            int a = 0;
            for (Object arg : args) {
                if (arg.getClass().equals(CyCLLocalSize.class)) {
                    this.kernel.setArgSize(a++, ((CyCLLocalSize)arg).getSize().longValue());
                    continue;
                }
                if (arg.getClass().equals(CyCLBuffer.class)) {
                    CL10.clSetKernelArg((CLKernel)this.kernel, (int)a++, (CLObject)((CyCLBuffer)arg).getMemObject());
                    continue;
                }
                if (arg.getClass().equals(CLMem.class)) {
                    CL10.clSetKernelArg((CLKernel)this.kernel, (int)a++, (CLObject)((CLMem)arg));
                    continue;
                }
                if (arg.getClass().equals(Byte.class)) {
                    this.kernel.setArg(a++, ((Byte)arg).byteValue());
                    continue;
                }
                if (arg.getClass().equals(Short.class)) {
                    this.kernel.setArg(a++, ((Short)arg).shortValue());
                    continue;
                }
                if (arg.getClass().equals(Integer.class)) {
                    this.kernel.setArg(a++, ((Integer)arg).intValue());
                    continue;
                }
                if (arg.getClass().equals(Long.class)) {
                    this.kernel.setArg(a++, ((Long)arg).longValue());
                    continue;
                }
                if (arg.getClass().equals(Float.class)) {
                    this.kernel.setArg(a++, ((Float)arg).floatValue());
                    continue;
                }
                if (!arg.getClass().equals(Double.class)) continue;
                this.kernel.setArg(a++, ((Double)arg).doubleValue());
            }
            PointerBuffer bufferGlobal = PointerBuffer.allocateDirect((int)dimsGlobal.length);
            for (int i = 0; i < dimsGlobal.length; ++i) {
                bufferGlobal.put(i, dimsGlobal[i]);
            }
            PointerBuffer bufferGlobalOffset = null;
            if (globalOffset != null) {
                if (globalOffset.length != dimsGlobal.length) {
                    throw new CyCLException("Global offset and global dimensions must have the same length");
                }
                bufferGlobalOffset = PointerBuffer.allocateDirect((int)globalOffset.length);
                for (int i = 0; i < globalOffset.length; ++i) {
                    bufferGlobalOffset.put(i, globalOffset[i]);
                }
            }
            PointerBuffer bufferLocal = null;
            if (dimsLocal != null) {
                bufferLocal = PointerBuffer.allocateDirect((int)dimsLocal.length);
                for (int i = 0; i < dimsLocal.length; ++i) {
                    bufferLocal.put(i, dimsLocal[i]);
                }
            }
            try {
                Util.checkCLError((int)CL10.clEnqueueNDRangeKernel((CLCommandQueue)this.context.getQueue(), (CLKernel)this.kernel, (int)dimsGlobal.length, (PointerBuffer)bufferGlobalOffset, (PointerBuffer)bufferGlobal, (PointerBuffer)bufferLocal, null, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        try {
            if (this.finalized.booleanValue()) {
                return;
            }
            Util.checkCLError((int)CL10.clReleaseKernel((CLKernel)this.kernel));
            this.finalized = true;
            super.finalize();
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLKernel " + this.kernel + ": " + exc.getMessage());
            throw new RuntimeException("Could not finalize CyCLKernel object.");
        }
    }
}

