/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.cycl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.cytoscape.opencl.cycl.CyCLBuffer;
import org.cytoscape.opencl.cycl.CyCLContext;
import org.cytoscape.opencl.cycl.CyCLException;
import org.cytoscape.opencl.cycl.CyCLProgram;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLPlatform;

public class CyCLDevice {
    private Boolean finalized = false;
    public String platformName;
    public final String name;
    public final String vendor;
    public final String version;
    public final DeviceTypes type;
    public final int computeUnits;
    public final long workItemDimensions;
    public final long[] maxWorkItemSizes;
    public final long maxWorkGroupSize;
    public final long clockFrequency;
    public final int addressBits;
    public final long maxMallocSize;
    public final long globalMemSize;
    public final boolean supportsECC;
    public final String localMemType;
    public final long localMemSize;
    public final long maxConstBufferSize;
    public final boolean supportsImages;
    public final int maxReadImageArgs;
    public final int maxWriteImageArgs;
    public final long[] image2DMaxSize;
    public final long[] image3DMaxSize;
    public final int prefWidthChar;
    public final int prefWidthShort;
    public final int prefWidthInt;
    public final int prefWidthLong;
    public final int prefWidthFloat;
    public final int prefWidthDouble;
    private final CLDevice device;
    private final CLPlatform devicePlatform;
    private final CyCLContext context;
    private final HashMap<String, CyCLProgram> programs;
    public final long bestBlockSize;
    public final long bestWarpSize;
    public final double benchmarkScore;

    private CyCLDevice(CLDevice device, CLPlatform platform, boolean doBenchmark) {
        this.device = device;
        this.devicePlatform = platform;
        this.context = new CyCLContext(this);
        this.programs = new HashMap();
        this.platformName = this.devicePlatform.getInfoString(2306);
        this.vendor = device.getInfoString(4140);
        this.version = device.getInfoString(4143);
        this.name = this.version + " " + device.getInfoString(4139);
        long longType = device.getInfoLong(4096);
        this.type = (longType & 4L) != 0L ? DeviceTypes.GPU : ((longType & 8L) != 0L ? DeviceTypes.Accelerator : DeviceTypes.CPU);
        this.computeUnits = device.getInfoInt(4098);
        this.workItemDimensions = device.getInfoLong(4099);
        this.maxWorkItemSizes = device.getInfoSizeArray(4101);
        this.maxWorkGroupSize = device.getInfoSize(4100);
        this.clockFrequency = device.getInfoLong(4108);
        this.addressBits = device.getInfoInt(4109);
        this.maxMallocSize = device.getInfoLong(4112);
        this.globalMemSize = device.getInfoLong(4127);
        this.supportsECC = device.getInfoInt(4132) > 0;
        this.localMemType = device.getInfoInt(4130) == 1 ? "local" : "global";
        this.localMemSize = device.getInfoLong(4131);
        this.maxConstBufferSize = device.getInfoLong(4128);
        this.supportsImages = device.getInfoInt(4118) > 0;
        this.maxReadImageArgs = device.getInfoInt(4110);
        this.maxWriteImageArgs = device.getInfoInt(4111);
        this.image2DMaxSize = new long[]{device.getInfoSize(4113), device.getInfoSize(4114)};
        this.image3DMaxSize = new long[]{device.getInfoSize(4115), device.getInfoSize(4116), device.getInfoSize(4117)};
        this.prefWidthChar = device.getInfoInt(4102);
        this.prefWidthShort = device.getInfoInt(4103);
        this.prefWidthInt = device.getInfoInt(4104);
        this.prefWidthLong = device.getInfoInt(4105);
        this.prefWidthFloat = device.getInfoInt(4106);
        this.prefWidthDouble = device.getInfoInt(4107);
        if (this.type == DeviceTypes.GPU) {
            if (this.platformName.toLowerCase().contains("amd")) {
                this.bestBlockSize = 128L;
                this.bestWarpSize = 64L;
            } else if (this.platformName.toLowerCase().contains("nvidia")) {
                this.bestBlockSize = 192L;
                this.bestWarpSize = 32L;
            } else if (this.platformName.toLowerCase().contains("intel")) {
                this.bestBlockSize = 128L;
                this.bestWarpSize = 32L;
            } else if (this.platformName.toLowerCase().contains("apple")) {
                String lowName = this.name.toLowerCase();
                if (lowName.contains("radeon") || lowName.contains("fire")) {
                    this.bestBlockSize = 128L;
                    this.bestWarpSize = 64L;
                } else if (lowName.contains("geforce") || lowName.contains("gtx") || lowName.contains("quadro") || lowName.contains("tesla")) {
                    this.bestBlockSize = 192L;
                    this.bestWarpSize = 32L;
                } else {
                    this.bestBlockSize = 128L;
                    this.bestWarpSize = 32L;
                }
            } else {
                this.bestBlockSize = 32L;
                this.bestWarpSize = 32L;
            }
        } else {
            this.bestBlockSize = 1L;
            this.bestWarpSize = 1L;
        }
        this.benchmarkScore = doBenchmark ? this.performBenchmark(false) : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double performBenchmark(boolean useOffsets) {
        CyCLProgram program = null;
        try {
            program = new CyCLProgram(this.context, this, this.getClass().getResource("/Benchmark.cl"), new String[]{"BenchmarkKernel"}, null, true);
        }
        catch (Exception e1) {
            throw new CyCLException("Could not build benchmark program.", e1);
        }
        try {
            int n = 8192;
            int[] a = new int[n];
            int[] b = new int[n];
            int[] c = new int[n];
            for (int i = 0; i < n; ++i) {
                a[i] = i;
                b[i] = i;
            }
            CyCLBuffer bufferA = new CyCLBuffer(this.context, a);
            CyCLBuffer bufferB = new CyCLBuffer(this.context, b);
            CyCLBuffer bufferC = new CyCLBuffer(this.context, Integer.TYPE, n);
            try {
                int i;
                program.getKernel("BenchmarkKernel").execute(new long[]{n}, null, bufferA, bufferB, bufferC, n);
                bufferC.getFromDevice(c);
                ArrayList<Double> logTimes = new ArrayList<Double>();
                for (int i2 = 0; i2 < 4; ++i2) {
                    long timeStart = System.nanoTime();
                    int benchN = 1 << 10 + i2;
                    if (!useOffsets) {
                        program.getKernel("BenchmarkKernel").execute(new long[]{benchN}, null, bufferA, bufferB, bufferC, benchN);
                    } else {
                        for (int offset = 0; offset < benchN; offset += 128) {
                            program.getKernel("BenchmarkKernel").executeWithOffset(new long[]{benchN}, null, new long[]{offset}, bufferA, bufferB, bufferC, benchN);
                        }
                    }
                    CL10.clFinish((CLCommandQueue)this.context.getQueue());
                    long timeStop = System.nanoTime();
                    logTimes.add(Math.log((double)(timeStop - timeStart) * 1.0E-9));
                }
                bufferC.getFromDevice(c);
                double diffsum = 0.0;
                for (i = 0; i < logTimes.size() - 1; ++i) {
                    diffsum += (Double)logTimes.get(i + 1) - (Double)logTimes.get(i);
                }
                diffsum /= (double)(logTimes.size() - 1);
                for (i = 0; i < c.length; ++i) {
                    if (c[i] == Math.max(0, i - 1)) continue;
                    throw new CyCLException("OpenCL benchmark produced wrong values.");
                }
                double d = Math.exp(diffsum);
                bufferA.free();
                bufferB.free();
                bufferC.free();
                return d;
            }
            catch (Throwable throwable) {
                try {
                    bufferA.free();
                    bufferB.free();
                    bufferC.free();
                    throw throwable;
                }
                catch (CyCLException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new CyCLException("Error running benchmark", ex);
                }
            }
        }
        finally {
            program.finalize();
        }
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public CLPlatform getPlatform() {
        return this.devicePlatform;
    }

    public long getBestBlockSize(long n) {
        return Math.min(this.bestBlockSize, (n + this.bestWarpSize - 1L) / this.bestWarpSize * this.bestWarpSize);
    }

    public Boolean hasProgram(String name) {
        return this.programs.containsKey(name);
    }

    public CyCLProgram getProgram(String name) {
        if (!this.hasProgram(name).booleanValue()) {
            return null;
        }
        return this.programs.get(name);
    }

    public CyCLProgram addProgram(String name, String[] programSources, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        if (this.hasProgram(name).booleanValue()) {
            return this.getProgram(name);
        }
        HashMap<String, String> alldefines = this.getDeviceSpecificDefines();
        if (defines != null) {
            alldefines.putAll(defines);
        }
        CyCLProgram added = new CyCLProgram(this.context, this, programSources, kernelNames, alldefines, silentCompilation);
        this.programs.put(name, added);
        return added;
    }

    public CyCLProgram addProgram(String name, String programSource, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        return this.addProgram(name, new String[]{programSource}, kernelNames, defines, silentCompilation);
    }

    public CyCLProgram addProgram(String name, URL resourcePath, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        if (this.hasProgram(name).booleanValue()) {
            return this.getProgram(name);
        }
        try {
            InputStream programTextStream = resourcePath.openStream();
            Scanner programTextScanner = new Scanner(programTextStream, "UTF-8");
            String programText = programTextScanner.useDelimiter("\\Z").next();
            programTextScanner.close();
            programTextStream.close();
            return this.addProgram(name, new String[]{programText}, kernelNames, defines, silentCompilation);
        }
        catch (IOException ex) {
            throw new CyCLException("Error reading OpenCL program.", ex);
        }
    }

    public CyCLProgram forceAddProgram(String name, URL resourcePath, String[] kernelNames, HashMap<String, String> defines, boolean silentCompilation) {
        CyCLProgram added;
        if (this.hasProgram(name).booleanValue()) {
            try {
                this.getProgram(name).finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.programs.remove(name);
        }
        HashMap<String, String> alldefines = this.getDeviceSpecificDefines();
        if (defines != null) {
            for (Map.Entry<String, String> entry : defines.entrySet()) {
                alldefines.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            added = new CyCLProgram(this.context, this, resourcePath, kernelNames, alldefines, silentCompilation);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        this.programs.put(name, added);
        return added;
    }

    public HashMap<String, String> getDeviceSpecificDefines() {
        HashMap<String, String> defines = new HashMap<String, String>();
        if (this.type == DeviceTypes.GPU) {
            defines.put("CYCL_GPU", "");
        } else {
            defines.put("CYCL_CPU", "");
        }
        defines.put("CYCL_WARP", String.valueOf(this.bestWarpSize));
        return defines;
    }

    public void finishQueue() {
        CL10.clFinish((CLCommandQueue)this.context.getQueue());
    }

    public CyCLBuffer createBuffer(Class<?> type, int elements) {
        return new CyCLBuffer(this.context, type, elements);
    }

    public CyCLBuffer createBuffer(byte[] data) {
        return new CyCLBuffer(this.context, data);
    }

    public CyCLBuffer createBuffer(short[] data) {
        return new CyCLBuffer(this.context, data);
    }

    public CyCLBuffer createBuffer(int[] data) {
        return new CyCLBuffer(this.context, data);
    }

    public CyCLBuffer createBuffer(long[] data) {
        return new CyCLBuffer(this.context, data);
    }

    public CyCLBuffer createBuffer(float[] data) {
        return new CyCLBuffer(this.context, data);
    }

    public CyCLBuffer createBuffer(double[] data) {
        return new CyCLBuffer(this.context, data);
    }

    protected void finalize() {
        try {
            if (this.finalized.booleanValue()) {
                return;
            }
            if (this.programs != null) {
                for (Map.Entry<String, CyCLProgram> entry : this.programs.entrySet()) {
                    if (entry.getValue() == null) continue;
                    entry.getValue().finalize();
                }
            }
            if (this.context != null) {
                this.context.finalize();
            }
            this.finalized = true;
            super.finalize();
        }
        catch (Throwable exc) {
            System.out.println("Could not finalize CyCLDevice " + this.name + ": " + exc.getMessage());
            throw new RuntimeException("Could not finalize CyCLDevice object.", exc);
        }
    }

    public static List<CyCLDevice> getAll(String preferredDevice) {
        ArrayList<CyCLDevice> devices = new ArrayList<CyCLDevice>();
        for (CLPlatform platform : CLPlatform.getPlatforms()) {
            for (CLDevice id : platform.getDevices(-1)) {
                try {
                    CyCLDevice newDevice = new CyCLDevice(id, platform, preferredDevice.equals(""));
                    devices.add(newDevice);
                }
                catch (Exception e1) {
                    throw new CyCLException(e1);
                }
            }
        }
        final class DeviceComparator
        implements Comparator<CyCLDevice> {
            final /* synthetic */ String val$preferredDevice;

            DeviceComparator(String string) {
                this.val$preferredDevice = string;
            }

            @Override
            public int compare(CyCLDevice o1, CyCLDevice o2) {
                if (o1.name.equals(this.val$preferredDevice)) {
                    return -1;
                }
                return Double.compare(o1.benchmarkScore, o2.benchmarkScore);
            }
        }
        devices.sort(new DeviceComparator(preferredDevice));
        return devices;
    }

    public static enum DeviceTypes {
        CPU,
        GPU,
        Accelerator;

    }
}

