/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.opencl.cycl;

import java.nio.IntBuffer;
import java.util.ArrayList;
import org.cytoscape.opencl.cycl.CyCLDevice;
import org.lwjgl.BufferUtils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.Util;

public class CyCLContext {
    private Boolean finalized = false;
    private CLContext context;
    private CLCommandQueue queue;

    public CyCLContext(CyCLDevice device) {
        ArrayList<CLDevice> devices = new ArrayList<CLDevice>();
        devices.add(device.getDevice());
        IntBuffer errorBuffer = BufferUtils.createIntBuffer((int)1);
        try {
            this.context = CLContext.create((CLPlatform)device.getPlatform(), devices, (IntBuffer)errorBuffer);
            Util.checkCLError((int)errorBuffer.get(0));
            this.queue = CL10.clCreateCommandQueue((CLContext)this.context, (CLDevice)device.getDevice(), (long)2L, (IntBuffer)errorBuffer);
            Util.checkCLError((int)errorBuffer.get(0));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create device context.");
        }
    }

    public CLContext getContext() {
        return this.context;
    }

    public CLCommandQueue getQueue() {
        return this.queue;
    }

    protected void finalize() throws Throwable {
        if (this.finalized.booleanValue()) {
            return;
        }
        CL10.clReleaseCommandQueue((CLCommandQueue)this.queue);
        CL10.clReleaseContext((CLContext)this.context);
        this.finalized = true;
        super.finalize();
    }
}

