/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.webservice.biomart.rest;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cytoscape.io.webservice.biomart.rest.Attribute;
import org.cytoscape.io.webservice.biomart.rest.Dataset;
import org.cytoscape.io.webservice.biomart.rest.Filter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLQueryBuilder {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder;

    public static String getQueryString(Dataset dataset, Attribute[] attrs, Filter[] filters) {
        Document doc = builder.newDocument();
        Element query = doc.createElement("Query");
        query.setAttribute("virtualSchemaName", "default");
        query.setAttribute("header", "1");
        query.setAttribute("uniqueRows", "1");
        query.setAttribute("count", "");
        query.setAttribute("datasetConfigVersion", "0.6");
        query.setAttribute("formatter", "TSV");
        doc.appendChild(query);
        Element ds = doc.createElement("Dataset");
        ds.setAttribute("name", dataset.getName());
        query.appendChild(ds);
        for (Attribute attr : attrs) {
            Element at = doc.createElement("Attribute");
            at.setAttribute("name", attr.getName());
            ds.appendChild(at);
        }
        if (filters != null && filters.length != 0) {
            for (Filter filter : filters) {
                Element ft = doc.createElement("Filter");
                ft.setAttribute("name", filter.getName());
                if (filter.getValue() == null) {
                    ft.setAttribute("excluded", "0");
                } else {
                    ft.setAttribute("value", filter.getValue());
                }
                ds.appendChild(ft);
            }
        }
        TransformerFactory tff = TransformerFactory.newInstance();
        String result = null;
        try {
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            StringWriter strWtr = new StringWriter();
            StreamResult strResult = new StreamResult(strWtr);
            tf.transform(new DOMSource(doc.getDocumentElement()), strResult);
            result = strResult.getWriter().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

