/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.sync;

import java.util.Map;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.internal.sync.DelegateTask;
import org.cytoscape.work.internal.sync.SyncTunableMutator;
import org.cytoscape.work.internal.sync.SyncTunableMutatorFactory;
import org.cytoscape.work.internal.sync.TunableRecorderManager;

public class TunableSetterImpl
implements TunableSetter {
    private final TunableRecorderManager trm;
    private SyncTunableMutatorFactory mutatorFactory;

    public TunableSetterImpl(SyncTunableMutatorFactory mutatorFactory, TunableRecorderManager trm) {
        this.mutatorFactory = mutatorFactory;
        this.trm = trm;
    }

    public TaskIterator createTaskIterator(TaskIterator ti, Map<String, Object> tunableValues) {
        return new TaskIterator(ti.getNumTasks(), new Task[]{new DelegateTask(this.mutatorFactory.createMutator(), this.trm, ti, tunableValues, null)});
    }

    public TaskIterator createTaskIterator(TaskIterator ti, Map<String, Object> tunableValues, TaskObserver observer) {
        return new TaskIterator(ti.getNumTasks(), new Task[]{new DelegateTask(this.mutatorFactory.createMutator(), this.trm, ti, tunableValues, observer)});
    }

    public void applyTunables(Object object, Map<String, Object> tunableValues) {
        SyncTunableMutator<?> mutator = this.mutatorFactory.createMutator();
        mutator.setConfigurationContext(tunableValues);
        mutator.validateAndWriteBack(object);
    }
}

