/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.sync;

import java.util.Map;
import org.cytoscape.work.AbstractTaskManager;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.TunableRecorder;
import org.cytoscape.work.internal.sync.LoggingTaskMonitor;
import org.cytoscape.work.internal.sync.SyncTunableMutator;

public class SyncTaskManager
extends AbstractTaskManager<Object, Map<String, Object>>
implements SynchronousTaskManager<Object> {
    private final SyncTunableMutator<?> syncTunableMutator;

    public SyncTaskManager(SyncTunableMutator<?> tunableMutator) {
        super(tunableMutator);
        this.syncTunableMutator = tunableMutator;
    }

    public void setExecutionContext(Map<String, Object> o) {
        this.syncTunableMutator.setConfigurationContext(o);
    }

    public Object getConfiguration(TaskFactory factory, Object context) {
        throw new UnsupportedOperationException("There is no configuration available for a SyncrhonousTaskManager");
    }

    public void execute(TaskIterator taskIterator, TaskObserver observer) {
        block6: {
            LoggingTaskMonitor taskMonitor = new LoggingTaskMonitor();
            Task task = null;
            try {
                while (taskIterator.hasNext()) {
                    task = taskIterator.next();
                    taskMonitor.setTask(task);
                    if (!this.displayTunables(task)) {
                        if (observer != null) {
                            observer.allFinished(FinishStatus.newCancelled((Task)task));
                        }
                        return;
                    }
                    task.run((TaskMonitor)taskMonitor);
                    if (!(task instanceof ObservableTask) || observer == null) continue;
                    observer.taskFinished((ObservableTask)task);
                }
                if (observer != null) {
                    observer.allFinished(FinishStatus.getSucceeded());
                }
            }
            catch (Exception exception) {
                taskMonitor.showException(exception);
                if (observer == null || task == null) break block6;
                observer.allFinished(FinishStatus.newFailed((Task)task, (Exception)exception));
            }
        }
    }

    public void execute(TaskIterator taskIterator) {
        this.execute(taskIterator, null);
    }

    private boolean displayTunables(Object task) throws Exception {
        if (task == null) {
            return true;
        }
        boolean ret = this.syncTunableMutator.validateAndWriteBack(task);
        for (TunableRecorder ti : this.tunableRecorders) {
            ti.recordTunableState(task);
        }
        return ret;
    }
}

