/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.properties;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.cytoscape.work.AbstractTunableHandler;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.properties.BasicTypePropertyHandler;
import org.cytoscape.work.properties.TunablePropertyHandler;
import org.cytoscape.work.util.AbstractBounded;
import org.cytoscape.work.util.BoundedDouble;
import org.cytoscape.work.util.BoundedFloat;
import org.cytoscape.work.util.BoundedInteger;
import org.cytoscape.work.util.BoundedLong;

public class BoundedPropertyHandler
extends AbstractTunableHandler
implements TunablePropertyHandler {
    public BoundedPropertyHandler(Field field, Object instance, Tunable tunable) {
        super(field, instance, tunable);
    }

    public BoundedPropertyHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
    }

    public static Class<?>[] supportedTypes() {
        return new Class[]{BoundedInteger.class, BoundedLong.class, BoundedDouble.class, BoundedFloat.class};
    }

    public void handle() {
    }

    protected AbstractBounded getContainer() {
        try {
            return (AbstractBounded)this.getValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Bad object", e);
        }
    }

    public String toPropertyValue() {
        return BasicTypePropertyHandler.toPropertyValue(this.getContainer().getValue());
    }

    public void parseAndSetValue(String propertyValue) {
        AbstractBounded container = this.getContainer();
        Class<?> elementType = this.getElementType();
        Object value = BasicTypePropertyHandler.parseValue(this.getName(), propertyValue, elementType);
        container.setValue((Comparable)value);
        try {
            this.setValue(container);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Class<?> getElementType() {
        Class type = this.getType();
        if (type == BoundedInteger.class) {
            return Integer.class;
        }
        if (type == BoundedLong.class) {
            return Long.class;
        }
        if (type == BoundedFloat.class) {
            return Float.class;
        }
        if (type == BoundedDouble.class) {
            return Double.class;
        }
        throw new IllegalArgumentException("Element type not supported: " + type);
    }
}

