/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui.downloadsites;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSite;
import org.cytoscape.property.CyProperty;

public class DownloadSitesManager {
    public static final String DOWNLOAD_SITES_COUNT_KEY = "appStoreDownloadSiteCount";
    public static final String DOWNLOAD_SITE_NAME_KEY_PREFIX = "appStoreDownloadSiteName";
    public static final String DOWNLOAD_SITE_URL_KEY_PREFIX = "appStoreDownloadSiteUrl";
    private List<DownloadSite> downloadSites = new LinkedList<DownloadSite>();
    private CyProperty<Properties> cyProperty;
    private Set<DownloadSitesChangedListener> downloadSitesChangedListeners;

    public DownloadSitesManager(CyProperty<Properties> cyProperty) {
        this.cyProperty = cyProperty;
        this.downloadSitesChangedListeners = new HashSet<DownloadSitesChangedListener>();
        this.loadDownloadSites();
    }

    public boolean loadDownloadSites() {
        LinkedList<DownloadSite> newDownloadSites = new LinkedList<DownloadSite>();
        boolean loadFailed = false;
        String downloadSiteCountString = ((Properties)this.cyProperty.getProperties()).getProperty(DOWNLOAD_SITES_COUNT_KEY);
        int downloadSiteCount = 0;
        if (downloadSiteCountString != null) {
            try {
                downloadSiteCount = Integer.parseInt(downloadSiteCountString);
            }
            catch (NumberFormatException e) {
                loadFailed = true;
            }
        } else {
            loadFailed = true;
        }
        if (!loadFailed) {
            for (int i = 0; i < downloadSiteCount; ++i) {
                int siteNumber = i + 1;
                String siteName = ((Properties)this.cyProperty.getProperties()).getProperty(DOWNLOAD_SITE_NAME_KEY_PREFIX + siteNumber);
                String siteUrl = ((Properties)this.cyProperty.getProperties()).getProperty(DOWNLOAD_SITE_URL_KEY_PREFIX + siteNumber);
                if (siteName == null || siteUrl == null) continue;
                newDownloadSites.add(new DownloadSite(siteName, siteUrl));
            }
            HashSet<Object> keysToRemove = new HashSet<Object>();
            for (Object key : ((Properties)this.cyProperty.getProperties()).keySet()) {
                if (!(key instanceof String)) continue;
                String keyString = (String)key;
                int siteNumber = 0;
                try {
                    if (keyString.startsWith(DOWNLOAD_SITE_NAME_KEY_PREFIX)) {
                        siteNumber = Integer.parseInt(keyString.substring(DOWNLOAD_SITE_NAME_KEY_PREFIX.length()).trim());
                    }
                    if (keyString.startsWith(DOWNLOAD_SITE_URL_KEY_PREFIX)) {
                        siteNumber = Integer.parseInt(keyString.substring(DOWNLOAD_SITE_URL_KEY_PREFIX.length()).trim());
                    }
                }
                catch (NumberFormatException e) {
                    siteNumber = 0;
                }
                if (siteNumber < downloadSiteCount + 1) continue;
                keysToRemove.add(key);
            }
            for (Object keyToRemove : keysToRemove) {
                ((Properties)this.cyProperty.getProperties()).remove(keyToRemove);
            }
            this.downloadSites = newDownloadSites;
            return true;
        }
        return false;
    }

    public void saveDownloadSites() {
        int siteCount = this.downloadSites.size();
        ((Properties)this.cyProperty.getProperties()).setProperty(DOWNLOAD_SITES_COUNT_KEY, String.valueOf(siteCount));
        for (int i = 0; i < siteCount; ++i) {
            int siteNumber = i + 1;
            String siteName = this.downloadSites.get(i).getSiteName();
            String siteUrl = this.downloadSites.get(i).getSiteUrl();
            ((Properties)this.cyProperty.getProperties()).setProperty(DOWNLOAD_SITE_NAME_KEY_PREFIX + siteNumber, siteName);
            ((Properties)this.cyProperty.getProperties()).setProperty(DOWNLOAD_SITE_URL_KEY_PREFIX + siteNumber, siteUrl);
        }
    }

    public List<DownloadSite> getDownloadSites() {
        return this.downloadSites;
    }

    public void addDownloadSitesChangedListener(DownloadSitesChangedListener listener) {
        this.downloadSitesChangedListeners.add(listener);
    }

    public void removeDownloadSitesChangedListener(DownloadSitesChangedListener listener) {
        this.downloadSitesChangedListeners.remove(listener);
    }

    public void addDownloadSite(DownloadSite downloadSite) {
        this.downloadSites.add(downloadSite);
        this.notifyDownloadSitesChanged();
    }

    public void removeDownloadSite(DownloadSite downloadSite) {
        this.downloadSites.remove(downloadSite);
        this.notifyDownloadSitesChanged();
    }

    public void notifyDownloadSitesChanged() {
        DownloadSitesChangedEvent event = new DownloadSitesChangedEvent(this);
        for (DownloadSitesChangedListener listener : this.downloadSitesChangedListeners) {
            listener.downloadSitesChanged(event);
        }
    }

    public static interface DownloadSitesChangedListener {
        public void downloadSitesChanged(DownloadSitesChangedEvent var1);
    }

    public class DownloadSitesChangedEvent {
        private DownloadSitesManager source;

        public DownloadSitesChangedEvent(DownloadSitesManager source) {
            this.source = source;
        }

        public DownloadSitesManager getSource() {
            return this.source;
        }
    }
}

