/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.cytoscape.app.internal.event.UpdatesChangedEvent;
import org.cytoscape.app.internal.event.UpdatesChangedListener;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.Update;
import org.cytoscape.app.internal.net.UpdateManager;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.task.InstallUpdatesTask;
import org.cytoscape.app.internal.ui.AppManagerDialog;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSite;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSitesManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;

public class CheckForUpdatesPanel
extends JPanel {
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JButton installAllButton;
    private JButton installSelectedButton;
    private JLabel lastCheckForUpdatesLabel;
    private JButton manageUpdateSites;
    private JLabel updateCheckTimeLabel;
    private JLabel updatesAvailableLabel;
    private JScrollPane updatesScrollPane;
    private JTable updatesTable;
    Container parent;
    private UpdateManager updateManager;
    private AppManager appManager;
    private DownloadSitesManager downloadSitesManager;
    private TaskManager taskManager;

    public CheckForUpdatesPanel(AppManager appManager, DownloadSitesManager downloadSitesManager, UpdateManager updateManager, TaskManager taskManager, Container parent) {
        this.updateManager = updateManager;
        this.appManager = appManager;
        this.downloadSitesManager = downloadSitesManager;
        this.taskManager = taskManager;
        this.initComponents();
        this.parent = parent;
    }

    private void initComponents() {
        this.updatesAvailableLabel = new JLabel("0 updates available.");
        this.installSelectedButton = new JButton("Update Selected");
        this.installAllButton = new JButton("Update All");
        this.updatesScrollPane = new JScrollPane();
        this.updatesTable = new JTable();
        this.lastCheckForUpdatesLabel = new JLabel("Last check for updates:");
        this.updateCheckTimeLabel = new JLabel("Today, at 6:00 pm");
        this.descriptionLabel = new JLabel("Update Description:");
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.manageUpdateSites = new JButton("Manage Sites...");
        this.installSelectedButton.setEnabled(false);
        this.installSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckForUpdatesPanel.this.installUpdates(CheckForUpdatesPanel.this.getSelectedUpdates());
            }
        });
        this.installAllButton.setEnabled(false);
        this.installAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckForUpdatesPanel.this.installUpdates(CheckForUpdatesPanel.this.updateManager.getUpdates());
            }
        });
        this.updatesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"App Name", "Version"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.updatesScrollPane.setViewportView(this.updatesTable);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setFocusable(false);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.manageUpdateSites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckForUpdatesPanel.this.manageUpdateSitesActionPerformed(evt);
            }
        });
        LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.installSelectedButton, this.installAllButton});
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.updatesAvailableLabel).addGap(10, 20, Short.MAX_VALUE).addComponent(this.lastCheckForUpdatesLabel).addComponent(this.updateCheckTimeLabel)).addComponent(this.updatesScrollPane, -1, 652, Short.MAX_VALUE).addComponent(this.descriptionLabel).addComponent(this.descriptionScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.installSelectedButton).addComponent(this.installAllButton).addGap(10, 20, Short.MAX_VALUE).addComponent(this.manageUpdateSites)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.updatesAvailableLabel).addComponent(this.lastCheckForUpdatesLabel).addComponent(this.updateCheckTimeLabel)).addComponent(this.updatesScrollPane, -1, 327, Short.MAX_VALUE).addComponent(this.descriptionLabel, -2, 16, -2).addComponent(this.descriptionScrollPane, -2, 106, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.installSelectedButton).addComponent(this.installAllButton).addComponent(this.manageUpdateSites)));
        this.updateManager.addUpdatesChangedListener(new UpdatesChangedListener(){

            @Override
            public void updatesChanged(UpdatesChangedEvent event) {
                int updateCount = CheckForUpdatesPanel.this.updateManager.getUpdates().size();
                CheckForUpdatesPanel.this.updatesAvailableLabel.setText(updateCount + " " + (updateCount == 1 ? "update" : "updates") + " available.");
                Calendar lastUpdateCheckTime = CheckForUpdatesPanel.this.updateManager.getLastUpdateCheckTime();
                int minute = lastUpdateCheckTime.get(12);
                CheckForUpdatesPanel.this.updateCheckTimeLabel.setText("Today, at " + (Serializable)(lastUpdateCheckTime.get(10) == 0 ? "12" : Integer.valueOf(lastUpdateCheckTime.get(10))) + ":" + (minute < 10 ? "0" : "") + minute + " " + (lastUpdateCheckTime.get(9) == 0 ? "am" : "pm"));
                CheckForUpdatesPanel.this.repopulateUpdatesTable();
                if (event.getSource().getUpdates().size() > 0) {
                    if (!CheckForUpdatesPanel.this.installAllButton.isEnabled()) {
                        CheckForUpdatesPanel.this.installAllButton.setEnabled(true);
                    }
                } else if (CheckForUpdatesPanel.this.installAllButton.isEnabled()) {
                    CheckForUpdatesPanel.this.installAllButton.setEnabled(false);
                }
            }
        });
        this.installAllButton.setEnabled(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CheckForUpdatesPanel.this.checkUpdates();
            }
        });
        this.setupDescriptionListener();
    }

    private void checkUpdates() {
        final Set<App> appsToCheckUpdates = this.appManager.getInstalledApps();
        this.taskManager.execute(new TaskIterator(new Task[]{new AbstractTask(){

            public void run(TaskMonitor taskMonitor) throws Exception {
                taskMonitor.setTitle("Checking for updates");
                CheckForUpdatesPanel.this.appManager.getAppManagerDialog().hideNetworkError();
                WebQuerier webQuerier = CheckForUpdatesPanel.this.appManager.getWebQuerier();
                webQuerier.setShowMultipleWarnings(true);
                double progress = 0.0;
                for (DownloadSite downloadSite : CheckForUpdatesPanel.this.downloadSitesManager.getDownloadSites()) {
                    String siteName = downloadSite.getSiteName();
                    String siteUrl = downloadSite.getSiteUrl();
                    taskMonitor.setStatusMessage("Obtaining apps listing from " + siteName + "(" + siteUrl + ") ...");
                    taskMonitor.setProgress(progress);
                    progress += 1.0 / (double)(CheckForUpdatesPanel.this.downloadSitesManager.getDownloadSites().size() + 1);
                    webQuerier.setCurrentSiteName(siteName);
                    webQuerier.setCurrentAppStoreUrl(siteUrl);
                    webQuerier.getAllApps();
                }
                webQuerier.setShowMultipleWarnings(false);
                taskMonitor.setStatusMessage("Reading listings for new versions");
                taskMonitor.setProgress(0.98);
                CheckForUpdatesPanel.this.updateManager.checkForUpdates(appsToCheckUpdates);
            }
        }}));
    }

    private void installUpdates(Set<Update> updates) {
        TaskIterator ti = new TaskIterator(new Task[0]);
        ti.append((Task)new InstallUpdatesTask(updates, this.appManager));
        this.taskManager.execute(ti, new TaskObserver(){

            public void taskFinished(ObservableTask task) {
            }

            public void allFinished(FinishStatus finishStatus) {
                CheckForUpdatesPanel.this.checkUpdates();
            }
        });
    }

    private void manageUpdateSitesActionPerformed(ActionEvent evt) {
        if (this.parent instanceof AppManagerDialog) {
            ((AppManagerDialog)this.parent).showManageDownloadSitesDialog();
        }
    }

    private void repopulateUpdatesTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CheckForUpdatesPanel.this.updatesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"App Name", "Current Version", "New Version", "Update URL"}){
                    boolean[] canEdit;
                    {
                        this.canEdit = new boolean[]{false, false, false, false};
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return this.canEdit[columnIndex];
                    }
                });
                DefaultTableModel tableModel = (DefaultTableModel)CheckForUpdatesPanel.this.updatesTable.getModel();
                for (Update update : CheckForUpdatesPanel.this.updateManager.getUpdates()) {
                    tableModel.addRow(new Object[]{update, update.getApp().getVersion(), update.getUpdateVersion(), (update.getRelease().getBaseUrl() + update.getRelease().getRelativeUrl()).replaceAll("//+", "/").replaceFirst(":/", "://")});
                }
            }
        });
    }

    private Set<Update> getSelectedUpdates() {
        HashSet<Update> selectedUpdates = new HashSet<Update>();
        int[] selectedRows = this.updatesTable.getSelectedRows();
        for (int index = 0; index < selectedRows.length; ++index) {
            Update update = (Update)this.updatesTable.getModel().getValueAt(this.updatesTable.convertRowIndexToModel(selectedRows[index]), 0);
            selectedUpdates.add(update);
        }
        return selectedUpdates;
    }

    private void setupDescriptionListener() {
        this.updatesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CheckForUpdatesPanel.this.updateDescriptionBox();
                }
            }
        });
    }

    private void updateDescriptionBox() {
        Set<Update> selectedUpdates = this.getSelectedUpdates();
        if (selectedUpdates.size() == 0) {
            this.descriptionTextArea.setText("");
            this.installSelectedButton.setEnabled(false);
        } else if (selectedUpdates.size() == 1) {
            Update update = selectedUpdates.iterator().next();
            this.descriptionTextArea.setText("");
            if (!this.installSelectedButton.isEnabled()) {
                this.installSelectedButton.setEnabled(true);
            }
        } else if (selectedUpdates.size() > 1) {
            this.descriptionTextArea.setText("");
            if (!this.installSelectedButton.isEnabled()) {
                this.installSelectedButton.setEnabled(true);
            }
        }
    }
}

