/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.UpdateManager;
import org.cytoscape.app.internal.ui.AppManagerDialog;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSitesManager;
import org.cytoscape.app.internal.util.AppUtil;
import org.cytoscape.application.events.CyShutdownEvent;
import org.cytoscape.application.events.CyShutdownListener;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.service.util.CyServiceRegistrar;

public class AppManagerMediator
implements CyShutdownListener {
    private AppManagerDialog dialog;
    private final AppManager appManager;
    private final DownloadSitesManager downloadSitesManager;
    private final UpdateManager updateManager;
    private final CyServiceRegistrar serviceRegistrar;

    public AppManagerMediator(AppManager appManager, DownloadSitesManager downloadSitesManager, UpdateManager updateManager, CyServiceRegistrar serviceRegistrar) {
        this.appManager = appManager;
        this.downloadSitesManager = downloadSitesManager;
        this.updateManager = updateManager;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(CyShutdownEvent e) {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public void showAppManager(boolean goToUpdates, ActionEvent evt) {
        if (this.dialog == null) {
            CySwingApplication swingApplication = (CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class);
            Window owner = AppUtil.getWindowAncestor(evt, swingApplication);
            this.dialog = new AppManagerDialog(owner, this.appManager, this.downloadSitesManager, this.updateManager, this.serviceRegistrar);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    AppManagerMediator.this.dialog = null;
                }
            });
        }
        if (goToUpdates) {
            this.dialog.changeTab(2);
        }
        this.dialog.setVisible(true);
    }

    public boolean isAppManagerVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }
}

