/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.ui;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.UpdateManager;
import org.cytoscape.app.internal.ui.CheckForUpdatesPanel;
import org.cytoscape.app.internal.ui.CurrentlyInstalledAppsPanel;
import org.cytoscape.app.internal.ui.InstallAppsPanel;
import org.cytoscape.app.internal.ui.NetworkErrorPanel;
import org.cytoscape.app.internal.ui.downloadsites.DownloadSitesManager;
import org.cytoscape.app.internal.ui.downloadsites.ManageDownloadSitesDialog;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class AppManagerDialog
extends JDialog {
    private CheckForUpdatesPanel checkForUpdatesPanel;
    private CurrentlyInstalledAppsPanel currentlyInstalledAppsPanel;
    private InstallAppsPanel installAppsPanel;
    private JTabbedPane mainTabbedPane;
    private NetworkErrorPanel networkErrorPanel;
    private ManageDownloadSitesDialog manageDownloadSitesDialog;
    private DownloadSitesManager downloadSitesManager;
    private final AppManager appManager;
    private final UpdateManager updateManager;
    private final CyServiceRegistrar serviceRegistrar;

    public AppManagerDialog(Window parent, AppManager appManager, DownloadSitesManager downloadSitesManager, UpdateManager updateManager, CyServiceRegistrar serviceRegistrar) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.appManager = appManager;
        this.downloadSitesManager = downloadSitesManager;
        this.updateManager = updateManager;
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
        this.manageDownloadSitesDialog = new ManageDownloadSitesDialog(parent, downloadSitesManager);
        this.manageDownloadSitesDialog.setLocationRelativeTo(this);
        this.setLocationRelativeTo(parent);
        appManager.setAppManagerDialog(this);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("App Manager");
        this.networkErrorPanel = new NetworkErrorPanel((IconManager)this.serviceRegistrar.getService(IconManager.class));
        this.networkErrorPanel.setVisible(false);
        FileUtil fileUtil = (FileUtil)this.serviceRegistrar.getService(FileUtil.class);
        DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
        this.installAppsPanel = new InstallAppsPanel(this.appManager, this.downloadSitesManager, fileUtil, iconManager, (TaskManager)taskManager, this);
        this.installAppsPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.currentlyInstalledAppsPanel = new CurrentlyInstalledAppsPanel(this.appManager);
        this.currentlyInstalledAppsPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.checkForUpdatesPanel = new CheckForUpdatesPanel(this.appManager, this.downloadSitesManager, this.updateManager, (TaskManager)taskManager, this);
        this.checkForUpdatesPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
        this.mainTabbedPane = new JTabbedPane();
        this.mainTabbedPane.addTab("Install Apps", this.installAppsPanel);
        this.mainTabbedPane.addTab("Currently Installed", this.currentlyInstalledAppsPanel);
        this.mainTabbedPane.addTab("Check for Updates", this.checkForUpdatesPanel);
        JButton closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppManagerDialog.this.dispose();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)closeButton, (String)"App_Manager");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.networkErrorPanel).addComponent(this.mainTabbedPane, -1, 640, Short.MAX_VALUE).addComponent(buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.networkErrorPanel).addComponent(this.mainTabbedPane, -1, 490, Short.MAX_VALUE).addComponent(buttonPanel));
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), null, (Action)closeButton.getAction());
        this.pack();
    }

    public void changeTab(int index) {
        this.mainTabbedPane.setSelectedIndex(index);
    }

    public void showManageDownloadSitesDialog() {
        if (this.manageDownloadSitesDialog != null) {
            this.manageDownloadSitesDialog.setLocationRelativeTo(this);
            this.manageDownloadSitesDialog.setVisible(true);
        }
    }

    public void showNetworkError(String errorMessage) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.showNetworkError(errorMessage));
        } else {
            this.networkErrorPanel.addMessage(errorMessage);
            this.networkErrorPanel.setVisible(true);
        }
    }

    public void hideNetworkError() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.hideNetworkError());
        } else {
            this.networkErrorPanel.clearMessages();
            this.networkErrorPanel.setVisible(false);
        }
    }
}

