/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.Update;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListUpdatesTask
extends AbstractAppTask
implements ObservableTask {
    private Set<Update> updates;

    public ListUpdatesTask(AppManager appManager) {
        super(appManager);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Listing available apps");
        WebQuerier webQuerier = this.appManager.getWebQuerier();
        Set<App> apps = this.appManager.getInstalledApps();
        this.updates = webQuerier.checkForUpdates(apps, this.appManager);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                StringBuilder stringBuilder = new StringBuilder("[");
                int count = this.updates.size();
                int index = 0;
                for (Update update : this.updates) {
                    App app = update.getApp();
                    stringBuilder.append("{\"appName\": \"" + app.getAppName() + "\",");
                    stringBuilder.append("\"version\": \"" + app.getVersion() + "\",");
                    stringBuilder.append("\"new version\": \"" + update.getUpdateVersion() + "\",");
                    if (index < count) {
                        stringBuilder.append(",");
                    }
                    ++index;
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            ArrayList<CallSite> appList = new ArrayList<CallSite>(this.updates.size());
            for (Update update : this.updates) {
                App app = update.getApp();
                appList.add((CallSite)((Object)("name: " + app.getAppName() + ", current version: " + app.getVersion() + ", new version: " + update.getUpdateVersion())));
            }
            Collections.sort(appList);
            Object list = "";
            for (String string : appList) {
                list = (String)list + string + "\n";
            }
            return (R)list;
        }
        if (type.equals(List.class)) {
            ArrayList<String> list = new ArrayList<String>();
            for (Update update : this.updates) {
                list.add(update.getApp().getAppName());
            }
            return (R)list;
        }
        return null;
    }
}

