/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.app.internal.util.AppUtil;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListAvailableTask
extends AbstractAppTask
implements ObservableTask {
    public ListAvailableTask(AppManager appManager) {
        super(appManager);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Listing available apps");
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                StringBuilder stringBuilder = new StringBuilder("[");
                int count = this.webAppList.size();
                int index = 0;
                for (WebApp app : this.webAppList) {
                    stringBuilder.append("{\"appName\": \"" + app.getName() + "\",");
                    stringBuilder.append("\"description\": " + AppUtil.quote(app.getDescription()) + ",");
                    if (app.getDetails() != null) {
                        stringBuilder.append("\"details\": " + AppUtil.quote(app.getDetails()) + "}");
                    } else {
                        stringBuilder.append("\"details\": \"\"}");
                    }
                    if (++index >= count) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            ArrayList<String> appList = new ArrayList<String>(this.webAppList.size());
            HashMap<String, WebApp> appMap = new HashMap<String, WebApp>();
            for (WebApp app : this.webAppList) {
                appList.add(app.getFullName().toLowerCase());
                appMap.put(app.getFullName().toLowerCase(), app);
            }
            Collections.sort(appList);
            Object list = "";
            for (String app : appList) {
                WebApp thisApp = (WebApp)appMap.get(app);
                list = (String)list + "name: " + thisApp.getFullName() + ", version: " + this.getVersion(thisApp) + "\n";
            }
            return (R)list;
        }
        if (type.equals(List.class)) {
            ArrayList<String> list = new ArrayList<String>();
            for (WebApp app : this.webAppList) {
                list.add(app.getFullName());
            }
            return (R)list;
        }
        return null;
    }
}

