/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.app.internal.task.InstallAppsFromFileTask;
import org.cytoscape.app.internal.task.InstallAppsFromWebAppTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class InstallTask
extends AbstractAppTask
implements ObservableTask {
    @Tunable(description="Name of app to install", longDescription="The name of the app to install", exampleStringValue="stringApp", context="nogui", required=false)
    public String app = null;
    String error = null;
    @Tunable(description="Jar file", longDescription="Location of file containing the app jar", exampleStringValue="/tmp/stringApp.jar", context="nogui", required=false)
    public File file = null;
    WebApp appObject = null;

    public InstallTask(AppManager appManager) {
        super(appManager);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.app == null && this.file == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Neither app name nor file provided");
            return;
        }
        taskMonitor.setTitle("Installing app " + this.app);
        if (this.file != null) {
            InstallAppsFromFileTask installTask = new InstallAppsFromFileTask(Collections.singletonList(this.file), this.appManager, false);
            this.insertTasksAfterCurrentTask(new Task[]{installTask});
        } else {
            this.appObject = this.getWebApp(this.app);
            if (this.appObject == null) {
                this.error = "Can't find app '" + this.app + "'";
                taskMonitor.showMessage(TaskMonitor.Level.ERROR, this.error);
                return;
            }
            InstallAppsFromWebAppTask installTask = new InstallAppsFromWebAppTask(Collections.singletonList(this.appObject), this.appManager, false);
            this.insertTasksAfterCurrentTask(new Task[]{installTask});
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.error != null) {
                    return "{\"error\": \"" + this.error + "\"}";
                }
                return "{}";
            };
            return (R)res;
        }
        if (type.equals(String.class)) {
            if (this.file != null) {
                return null;
            }
            if (this.error != null) {
                return (R)this.error;
            }
            String res = "App " + this.app + " installed";
            return (R)res;
        }
        return null;
    }
}

