/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.task.ResolveAppDependenciesTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class InstallAppsFromFileTask
extends AbstractTask {
    final Collection<File> appFiles;
    final AppManager appManager;
    final boolean promptToReplace;

    public InstallAppsFromFileTask(Collection<File> appFiles, AppManager appManager, boolean promptToReplace) {
        this.appFiles = appFiles;
        this.appManager = appManager;
        this.promptToReplace = promptToReplace;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Install from File");
        taskMonitor.setTitle("");
        ArrayList<App> apps = new ArrayList<App>();
        for (File appFile : this.appFiles) {
            App app = this.appManager.getAppParser().parseApp(appFile);
            apps.add(app);
        }
        taskMonitor.setStatusMessage("Starting install...");
        this.insertTasksAfterCurrentTask(new Task[]{new ResolveAppDependenciesTask(apps, this.appManager, this.promptToReplace)});
    }
}

