/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.net.WebApp;
import org.cytoscape.app.internal.task.AbstractAppTask;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class AppStoreTask
extends AbstractAppTask
implements ObservableTask {
    final CyServiceRegistrar serviceRegistrar;
    static final String APP_STORE = "https://apps.cytoscape.org/";
    private String url = null;
    @Tunable(description="App name", context="nogui")
    public String app;
    @Tunable(description="Use CyBrowser if installed", context="nogui")
    public boolean useCybrowser = true;

    public AppStoreTask(AppManager appManager, CyServiceRegistrar serviceRegistrar) {
        super(appManager);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        WebApp webApp = null;
        if (this.app != null) {
            webApp = this.getWebApp(this.app);
            this.url = "https://apps.cytoscape.org/apps/" + this.app;
        } else {
            this.url = APP_STORE;
        }
        App cyBrowser = this.getApp("cybrowser");
        if (this.useCybrowser && cyBrowser != null && cyBrowser.getStatus() == App.AppStatus.INSTALLED) {
            CommandExecutorTaskFactory commandTF = (CommandExecutorTaskFactory)this.serviceRegistrar.getService(CommandExecutorTaskFactory.class);
            TaskManager taskManager = (TaskManager)this.serviceRegistrar.getService(TaskManager.class);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("url", this.url);
            args.put("id", "AppStore");
            TaskIterator ti = commandTF.createTaskIterator("cybrowser", "dialog", args, null);
            taskManager.execute(ti);
        } else {
            OpenBrowser openBrowser = (OpenBrowser)this.serviceRegistrar.getService(OpenBrowser.class);
            openBrowser.openURL(this.url);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return (R)res;
        }
        if (type.equals(String.class)) {
            String res = "Opened url: " + this.url;
            return (R)res;
        }
        return null;
    }
}

