/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net.server;

import org.cytoscape.app.internal.net.server.CyHttpBeforeResponse;
import org.cytoscape.app.internal.net.server.CyHttpRequest;
import org.cytoscape.app.internal.net.server.CyHttpResponse;
import org.cytoscape.app.internal.net.server.CyHttpResponseFactory;
import org.cytoscape.app.internal.net.server.CyHttpResponseFactoryImpl;

public class OriginOptionsBeforeResponse
implements CyHttpBeforeResponse {
    static final CyHttpResponseFactory responseFactory = new CyHttpResponseFactoryImpl();
    final String allowedHeadersFmt;

    public OriginOptionsBeforeResponse(String ... allowedHeaders) {
        StringBuffer allowedHeadersBuffer = new StringBuffer("origin, content-type, accept, authorization");
        for (String allowedHeader : allowedHeaders) {
            allowedHeadersBuffer.append(", ");
            allowedHeadersBuffer.append(allowedHeader);
        }
        this.allowedHeadersFmt = allowedHeadersBuffer.toString();
    }

    @Override
    public CyHttpResponse intercept(CyHttpRequest request) {
        if (!"OPTIONS".equals(request.getMethod())) {
            return null;
        }
        String origin = request.getHeaders().get("Origin");
        CyHttpResponse response = responseFactory.createHttpResponse(200);
        response.getHeaders().put("Access-Control-Allow-Origin", origin == null ? "*" : origin);
        response.getHeaders().put("Access-Control-Allow-Methods", "POST, PUT, GET, OPTIONS");
        response.getHeaders().put("Access-Control-Max-Age", "1");
        response.getHeaders().put("Access-Control-Allow-Headers", this.allowedHeadersFmt);
        return response;
    }
}

