/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.util.EntityUtils;
import org.cytoscape.app.internal.net.server.CyHttpRequest;

public class CyHttpRequestImpl
implements CyHttpRequest {
    final String uri;
    final String method;
    final Map<String, String> headers;
    final String content;
    final String contentType;

    public CyHttpRequestImpl(HttpRequest request) {
        String uriEncoded = request.getRequestLine().getUri();
        try {
            this.uri = URLDecoder.decode(uriEncoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unable to parse URI: " + uriEncoded, e);
        }
        this.method = request.getRequestLine().getMethod().toUpperCase();
        this.headers = new HashMap<String, String>();
        for (Header header : request.getAllHeaders()) {
            String name = header.getName();
            Object value = header.getValue();
            if (this.headers.containsKey(name)) {
                value = this.headers.get(name) + "\n" + (String)value;
            }
            this.headers.put(name, (String)value);
        }
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            this.contentType = entity.getContentType().getValue();
            try {
                this.content = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read entity as string", e);
            }
        } else {
            this.contentType = null;
            this.content = null;
        }
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

