/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.net;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.net.WebQuerier;
import org.cytoscape.app.internal.util.AppHelper;
import org.cytoscape.application.CyVersion;

public class WebApp {
    private String name;
    private String fullName;
    private String appListDisplayName;
    private String description;
    private String details;
    private String iconUrl;
    private String pageUrl;
    private int downloadCount;
    private int starsPercentage;
    private int votes;
    private Set<WebQuerier.AppTag> appTags = new HashSet<WebQuerier.AppTag>();
    private String compatibleCytoscapeVersion;
    private String citation;
    private ImageIcon imageIcon;
    private List<Release> releases = new LinkedList<Release>();
    private App correspondingApp = null;

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getAppListDisplayName() {
        return this.appListDisplayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetails() {
        return this.details;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public Set<WebQuerier.AppTag> getAppTags() {
        return this.appTags;
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public int getDownloadCount() {
        return this.downloadCount;
    }

    public int getStarsPercentage() {
        return this.starsPercentage;
    }

    public int getVotes() {
        return this.votes;
    }

    public String getCompatibleCytoscapeVersion() {
        return this.compatibleCytoscapeVersion;
    }

    public String getCitation() {
        return this.citation;
    }

    public List<Release> getReleases() {
        return this.releases;
    }

    public App getCorrespondingApp() {
        return this.correspondingApp;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAppListDisplayName(String appListDisplayName) {
        this.appListDisplayName = appListDisplayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public void setDownloadCount(int downloadCount) {
        this.downloadCount = downloadCount;
    }

    public void setStarsPercentage(int starsPercentage) {
        this.starsPercentage = starsPercentage;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    public void setAppTags(Set<WebQuerier.AppTag> appTags) {
        this.appTags = appTags;
    }

    public void setCompatibleCytoscapeVersion(String compatibleCytoscapeVersion) {
        this.compatibleCytoscapeVersion = compatibleCytoscapeVersion;
    }

    public void setCitation(String citation) {
        this.citation = citation;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    public void setReleases(List<Release> releases) {
        this.releases = releases;
    }

    public void setCorrespondingApp(App app) {
        this.correspondingApp = app;
    }

    public String toString() {
        return this.appListDisplayName;
    }

    public class Release
    implements Comparable<Release> {
        private String baseUrl;
        private String relativeUrl;
        private String releaseDate;
        private String releaseVersion;
        private String compatibleCytoscapeVersions;

        @Override
        public int compareTo(Release other) {
            return this.releaseDate.compareToIgnoreCase(other.releaseDate);
        }

        public WebApp getWebApp() {
            return WebApp.this;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getRelativeUrl() {
            return this.relativeUrl;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public String getReleaseVersion() {
            return this.releaseVersion;
        }

        public String getCompatibleCytoscapeVersions() {
            return this.compatibleCytoscapeVersions;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setRelativeUrl(String relativeUrl) {
            this.relativeUrl = relativeUrl;
        }

        public void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        public void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        public void setCompatibleCytoscapeVersions(String compatibleCytoscapeVersions) {
            this.compatibleCytoscapeVersions = compatibleCytoscapeVersions;
        }

        public boolean isCompatible(CyVersion cyVer) {
            return AppHelper.isCompatible(cyVer, this.compatibleCytoscapeVersions);
        }
    }
}

