/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import org.cytoscape.app.internal.manager.Range;
import org.cytoscape.app.internal.manager.Version;
import org.cytoscape.app.internal.util.AppUtil;
import org.cytoscape.app.internal.util.MiniTest;

public class ParseAppDependencies {
    private static final char PACKAGE_DELIMITER = ',';
    private static final char ATTR_DELIMITER = ';';
    private static final char VALUE_DELIMITER = '=';
    private static final String PSEUDO_NAME = "#name";
    private static final String VERSION_ATTR = "version";

    private static ArrayList<String> splitByPkg(String packageList) {
        return AppUtil.splitByChar(packageList.trim(), ',');
    }

    private static AbstractMap<String, String> mapAppAttrs(String app) throws Exception {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        String[] attrList = AppUtil.dumbSplit(app, ';');
        for (int index = 0; index < attrList.length; ++index) {
            String attr = attrList[index];
            if (index == 0) {
                attrMap.put(PSEUDO_NAME, attr);
                continue;
            }
            String attrName = attr;
            String attrValue = null;
            int indexDelimiter = attr.indexOf(61);
            if (indexDelimiter >= 0) {
                attrName = attr.substring(0, indexDelimiter);
                attrValue = attr.substring(indexDelimiter + 1).trim();
                if (attrValue.length() >= 2 && attrValue.startsWith("\"") && attrValue.endsWith("\"")) {
                    attrValue = attrValue.substring(1, attrValue.length() - 1);
                }
            }
            if ((attrName = attrName.trim()).length() == 0) {
                throw new Exception("Attribute missing name " + attr);
            }
            attrMap.put(attrName, attrValue);
        }
        return attrMap;
    }

    private static AbstractMap<String, Range> parseAppNameDependencies(String manifestList, String packageQualifier) throws Exception {
        HashMap<String, Range> appVersions = new HashMap<String, Range>();
        ArrayList<String> appList = ParseAppDependencies.splitByPkg(manifestList);
        for (String app : appList) {
            if (!app.startsWith(packageQualifier)) continue;
            AbstractMap<String, String> attrs = ParseAppDependencies.mapAppAttrs(app);
            String appName = attrs.get(PSEUDO_NAME);
            if (appName != null && appName.length() > 0) {
                try {
                    ((AbstractMap)appVersions).put(appName, new Range(attrs.get(VERSION_ATTR)));
                    continue;
                }
                catch (Throwable t) {
                    throw new Exception("for app " + appName + ":" + t);
                }
            }
            throw new Exception("no app name specified");
        }
        return appVersions;
    }

    private static boolean checkVersions(AbstractMap<String, Range> appVersions, Version checkVersion) {
        for (String app : appVersions.keySet()) {
            Range appRange = appVersions.get(app);
            if (appRange.inRange(checkVersion)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkVersions(String manifestList, String moduleFilter, String checkVersion) throws Exception {
        AbstractMap<String, Range> cytoRanges = ParseAppDependencies.parseAppNameDependencies(manifestList, moduleFilter);
        return ParseAppDependencies.checkVersions(cytoRanges, new Version(checkVersion));
    }

    public static void main(String[] args) {
        String manifestExample = "javax.swing,org.cytoscape.application;version=\"[3.0,4)\",org.cytoscape.diagnostics,org.cytoscape.io.util;version=\"[3.0,4)\",org.cytoscape.service.util;version=\"[3.0,4)\",org.cytoscape.work;version=\"[3.0,4)\",org.osgi.framework;version=\"[1.5,2)\"javax.swing,org.cytoscape.application;version=\"[3.0,4)\",org.cytoscape.diagnostics,org.cytoscape.io.util;version=\"[3.0,4)\",org.cytoscape.service.util;version=\"[3.0,4)\",org.cytoscape.work;version=\"[3.0,4)\",org.osgi.framework;version=\"[1.5,2)\",javax.swing,javax.swing.border,javax.swing.event,javax.swing.plaf,javax.swing.plaf.basic,javax.swing.table,javax.swing.text,javax.swing.text.html,org.cytoscape.application;version=\"[3.2,4)\",org.cytoscape.application.events;version=\"[3.2,4)\",org.cytoscape.application.swing;version=\"[3.2,4)\",org.cytoscape.application.swing.events;version=\"[3.2,4)\",org.cytoscape.event;version=\"[3.2,4)\",org.cytoscape.model;version=\"[3.2,4)\",org.cytoscape.model.events;version=\"[3.2,4)\",org.cytoscape.model.subnetwork;version=\"[3.2,4)\",org.cytoscape.service.util;version=\"[3.2,4)\",org.cytoscape.util.swing;version=\"[3.2,4)\",org.cytoscape.view.model;version=\"[3.2,4)\",org.cytoscape.view.presentation;version=\"[3.2,4)\",org.cytoscape.view.presentation.property;version=\"[3.2,4)\",org.cytoscape.view.presentation.property.values;version=\"[3.2,4)\",org.cytoscape.view.vizmap;version=\"[3.2,4)\",org.cytoscape.view.vizmap.mappings;version=\"[3.2,4)\",org.cytoscape.work;version=\"[3.2,4)\",org.osgi.framework;version=\"[1.5,2)\",org.slf4j;version=\"[1.5,2)\",javax.swing,javax.swing.border,javax.swing.event,javax.swing.plaf,javax.swing.plaf.basic,javax.swing.table,javax.swing.text,javax.swing.text.html,org.cytoscape.application;version=\"[3.2,4)\",org.cytoscape.application.events;version=\"[3.2,4)\",org.cytoscape.application.swing;version=\"[3.2,4)\",org.cytoscape.application.swing.events;version=\"[3.2,4)\",org.cytoscape.event;version=\"[3.2,4)\",org.cytoscape.model;version=\"[3.2,4)\",org.cytoscape.model.events;version=\"[3.2,4)\",org.cytoscape.model.subnetwork;version=\"[3.2,4)\",org.cytoscape.service.util;version=\"[3.2,4)\",org.cytoscape.util.swing;version=\"[3.2,4)\",org.cytoscape.view.model;version=\"[3.2,4)\",org.cytoscape.view.presentation;version=\"[3.2,4)\",org.cytoscape.view.presentation.property;version=\"[3.2,4)\",org.cytoscape.view.presentation.property.values;version=\"[3.2,4)\",org.cytoscape.view.vizmap;version=\"[3.2,4)\",org.cytoscape.view.vizmap.mappings;version=\"[3.2,4)\",org.cytoscape.work;version=\"[3.2,4)\",org.osgi.framework;version=\"[1.5,2)\",org.slf4j;version=\"[1.5,2)\"";
        try {
            AbstractMap<String, Range> cytoRanges = ParseAppDependencies.parseAppNameDependencies(manifestExample, "org.cytoscape");
            MiniTest.isTrue(!ParseAppDependencies.checkVersions(cytoRanges, new Version("2.8.3")), "2.8.3 not in range");
            MiniTest.isTrue(!ParseAppDependencies.checkVersions(cytoRanges, new Version("3")), "3 not in range");
            MiniTest.isTrue(!ParseAppDependencies.checkVersions(cytoRanges, new Version("3.0")), "3.0 not in range");
            MiniTest.isTrue(ParseAppDependencies.checkVersions(cytoRanges, new Version("3.2.1")), "3.2.1 in range");
            MiniTest.isTrue(!ParseAppDependencies.checkVersions(cytoRanges, new Version("4")), "4 not in range");
            MiniTest.isTrue(!ParseAppDependencies.checkVersions(manifestExample, "org.cytoscape", "2.8.3"), "2.8.3 not in range");
            MiniTest.isTrue(ParseAppDependencies.checkVersions(manifestExample, "org.cytoscape", "3.2.1"), "3.2.1 in range");
            MiniTest.isTrue(ParseAppDependencies.checkVersions(manifestExample, "puretrash", "3.2.1"), "3.2.1 in range of empty app list");
            MiniTest.isTrue(ParseAppDependencies.checkVersions("", "org.cytoscape", "3.2.1"), "3.2.1 in range of empty manifest");
        }
        catch (Throwable t) {
            System.out.println(t);
            System.exit(-1);
        }
    }
}

