/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import org.cytoscape.app.internal.exception.AppLoadingException;
import org.cytoscape.app.internal.exception.AppStartupException;
import org.cytoscape.app.internal.exception.AppStoppingException;
import org.cytoscape.app.internal.exception.AppUnloadingException;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.AppManager;
import org.cytoscape.app.internal.manager.ParseAppDependencies;
import org.cytoscape.application.CyVersion;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleApp
extends App {
    private Bundle bundleInstance;

    @Override
    public String getReadableStatus() {
        switch (this.getStatus()) {
            case INACTIVE: {
                if (this.bundleInstance != null) {
                    return "Inactive on Restart";
                }
                return "Inactive";
            }
            case DISABLED: {
                if (this.bundleInstance != null) {
                    return "Disable on Restart";
                }
                return "Disabled";
            }
            case UNINSTALLED: {
                if (this.bundleInstance != null) {
                    return "Uninstall on Restart";
                }
                return "Uninstalled";
            }
            case FILE_MOVED: {
                return "File Moved (Needs restart to uninstall)";
            }
        }
        return super.getReadableStatus();
    }

    @Override
    public void load(AppManager appManager) throws AppLoadingException {
        if (this.bundleInstance == null) {
            try {
                this.bundleInstance = appManager.getBundleContext().installBundle(this.getAppFile().toURI().toString());
            }
            catch (BundleException e) {
                throw new AppLoadingException("Bundle install error", e);
            }
        }
    }

    @Override
    public void start(AppManager appManager) throws AppStartupException {
        if (this.bundleInstance != null) {
            try {
                this.bundleInstance.start();
            }
            catch (BundleException e) {
                throw new AppStartupException("Bundle start error", e);
            }
        }
    }

    @Override
    public void stop(AppManager appManager) throws AppStoppingException {
        if (this.bundleInstance != null) {
            try {
                this.bundleInstance.stop();
            }
            catch (BundleException e) {
                throw new AppStoppingException("Bundle stop error", e);
            }
        }
    }

    @Override
    public void unload(AppManager appManager) throws AppUnloadingException {
        if (this.bundleInstance != null) {
            try {
                this.bundleInstance.uninstall();
                this.bundleInstance = null;
            }
            catch (BundleException e) {
                throw new AppUnloadingException("Bundle uninstall error", e);
            }
        }
    }

    @Override
    public boolean isCompatible(CyVersion cyVer) {
        try {
            return ParseAppDependencies.checkVersions(this.getCompatibleVersions(), "org.cytoscape", cyVer.getVersion());
        }
        catch (Exception e) {
            return false;
        }
    }
}

