/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.app.internal.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.cytoscape.app.internal.exception.AppParsingException;
import org.cytoscape.app.internal.manager.App;
import org.cytoscape.app.internal.manager.BundleApp;
import org.cytoscape.app.internal.manager.SimpleApp;
import org.cytoscape.app.internal.util.DebugHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppParser {
    public static final String APP_CLASS_TAG = "Cytoscape-App";
    public static final String APP_READABLE_NAME_TAG = "Cytoscape-App-Name";
    public static final String APP_VERSION_TAG = "Cytoscape-App-Version";
    public static final String APP_COMPATIBLE_TAG = "Cytoscape-API-Compatibility";
    public static final Pattern APP_VERSION_TAG_REGEX = Pattern.compile("(0|([1-9]+\\d*))\\.(\\d)+(\\.(\\d)+)?(.*)?");
    private static final String APP_COMPATIBLE_TAG_REGEX = "(\\d+(\\.\\d+)?\\s*)(,\\s*\\d+(\\.\\d+)?\\s*)*";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public App parseApp(File file) throws AppParsingException {
        App parsedApp = new SimpleApp();
        DebugHelper.print("Parsing: " + file.getPath());
        if (!file.exists()) {
            throw new AppParsingException("No file with path: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new AppParsingException("The given file, " + file + ", is not a file.");
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            throw new AppParsingException("Error parsing given file as a jar file: " + e.getMessage());
        }
        boolean bundleApp = false;
        boolean xmlParseFailed = false;
        boolean osgiMetadataFound = false;
        try {
            Manifest osgiManifest = jarFile.getManifest();
            if (osgiManifest != null && osgiManifest.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
                osgiMetadataFound = true;
            }
        }
        catch (IOException osgiManifest) {
            // empty catch block
        }
        if (osgiMetadataFound) {
            bundleApp = true;
            parsedApp = new BundleApp();
        }
        Manifest manifest = null;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            throw new AppParsingException("Error obtaining manifest from app jar", e);
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                throw new AppParsingException("Error closing file", e);
            }
        }
        if (manifest == null) {
            throw new AppParsingException("No manifest was found in the jar file.");
        }
        String entryClassName = null;
        if (!bundleApp) {
            entryClassName = manifest.getMainAttributes().getValue(APP_CLASS_TAG);
            if (entryClassName == null || entryClassName.trim().length() == 0) {
                throw new AppParsingException("Jar is missing value for entry Cytoscape-App in its manifest file.");
            }
        } else {
            entryClassName = manifest.getMainAttributes().getValue("Bundle-Activator");
            if (entryClassName == null || entryClassName.trim().length() == 0) {
                throw new AppParsingException("Jar is missing value for entry Bundle-Activator");
            }
        }
        String readableName = null;
        if (!bundleApp) {
            readableName = manifest.getMainAttributes().getValue(APP_READABLE_NAME_TAG);
            if (readableName == null || readableName.trim().length() == 0) {
                throw new AppParsingException("Jar is missing value for entry Cytoscape-App-Name in its manifest file.");
            }
        } else {
            readableName = manifest.getMainAttributes().getValue("Bundle-Name");
            if (readableName == null || readableName.trim().length() == 0) {
                readableName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
            }
            if (readableName == null || readableName.trim().length() == 0) {
                throw new AppParsingException("Bundle jar manifest had no entry for Bundle-Name, and no entry for Bundle-SymbolicName");
            }
        }
        String appVersion = null;
        if (!bundleApp) {
            appVersion = manifest.getMainAttributes().getValue(APP_VERSION_TAG);
            if (appVersion == null || appVersion.trim().length() == 0) {
                throw new AppParsingException("Jar is missing value for entry Cytoscape-App-Version in its manifiest file.");
            }
            if (!APP_VERSION_TAG_REGEX.matcher(appVersion).matches()) {
                throw new AppParsingException("The app version specified in its manifest file under the key Cytoscape-App-Version was found to not match the format major.minor[.patch][-tag], eg. 2.1, 2.1-test, 3.0.0 or 3.0.0-SNAPSHOT");
            }
        } else {
            appVersion = manifest.getMainAttributes().getValue("Bundle-Version");
            if (!(appVersion != null && appVersion.trim().length() != 0 || (appVersion = manifest.getMainAttributes().getValue(APP_VERSION_TAG)) != null && appVersion.trim().length() != 0)) {
                throw new AppParsingException("Bundle jar manifest has no entry for Bundle-Version");
            }
        }
        String compatibleVersions = null;
        if (bundleApp) {
            compatibleVersions = manifest.getMainAttributes().getValue("Import-Package");
            if (compatibleVersions == null || compatibleVersions.trim().length() == 0) {
                throw new AppParsingException("Jar is missing value for entry Import-Package in its manifest file.");
            }
        } else {
            compatibleVersions = manifest.getMainAttributes().getValue(APP_COMPATIBLE_TAG);
            if (compatibleVersions == null || compatibleVersions.trim().length() == 0) {
                compatibleVersions = manifest.getMainAttributes().getValue("Cytoscape-App-Works-With");
            }
            if (compatibleVersions == null || compatibleVersions.trim().length() == 0) {
                throw new AppParsingException("Jar is missing value for entry Cytoscape-API-Compatibility in its manifest file.");
            }
            if (!compatibleVersions.matches(APP_COMPATIBLE_TAG_REGEX)) {
                throw new AppParsingException("The known compatible versions of Cytoscape specified in the manifest under the key Cytoscape-API-Compatibility does not match the form of a comma-delimited list of versions of the form major[.minor] (eg. 1 or 1.0) with variable whitespace around versions");
            }
        }
        ArrayList<App.Dependency> deps = null;
        String depsStr = manifest.getMainAttributes().getValue("Cytoscape-App-Dependencies");
        if (depsStr != null && depsStr.trim().length() != 0) {
            String[] depsPieces;
            deps = new ArrayList<App.Dependency>();
            for (String depPiece : depsPieces = AppParser.splitSmart(',', depsStr)) {
                String[] depPieces = AppParser.splitSmart(';', depPiece);
                if (depPieces.length < 2) {
                    throw new AppParsingException("Each dependency must have a name and version");
                }
                deps.add(new App.Dependency(depPieces[0], depPieces[1]));
            }
        }
        parsedApp.setAppFile(file);
        parsedApp.setAppName(readableName);
        parsedApp.setEntryClassName(entryClassName);
        parsedApp.setVersion(appVersion);
        parsedApp.setCompatibleVersions(compatibleVersions);
        parsedApp.setAppValidated(true);
        parsedApp.setDependencies(deps);
        return parsedApp;
    }

    @Deprecated
    private String getChecksum(File file) throws ChecksumException {
        InputStream inputStream;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ChecksumException("Unable to obtain SHA-512 algorithm implementation");
        }
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ChecksumException("File " + file.getAbsolutePath() + " does not exist.");
        }
        try {
            inputStream = new DigestInputStream(inputStream, messageDigest);
            byte[] byteBuffer = new byte[128];
            while (inputStream.available() != 0) {
                inputStream.read(byteBuffer);
            }
        }
        catch (IOException e) {
            throw new ChecksumException("Error reading from file " + file + ", " + e.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        byte[] digest = messageDigest.digest();
        Object result = "";
        for (int i = 0; i < digest.length; ++i) {
            result = (String)result + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
        }
        return "sha512:" + (String)result;
    }

    private static int findChar(char lookForThis, String inThis, int startingAt) {
        int len = inThis.length();
        for (int i = startingAt; i < len; ++i) {
            char c = inThis.charAt(i);
            if (c == '\"') {
                ++i;
                while (i < len && (c = inThis.charAt(i)) != '\"') {
                    ++i;
                }
                continue;
            }
            if (lookForThis != c) continue;
            return i;
        }
        return len;
    }

    private static String[] splitSmart(char splitBy, String whatToSplit) {
        int len = whatToSplit.length();
        int numPieces = 0;
        int i = 0;
        while (i < len) {
            i = AppParser.findChar(splitBy, whatToSplit, i) + 1;
            ++numPieces;
        }
        String[] pieces = new String[numPieces];
        int pi = 0;
        int i2 = 0;
        while (i2 < len) {
            int j = AppParser.findChar(splitBy, whatToSplit, i2);
            String piece = whatToSplit.substring(i2, j);
            if ((piece = piece.trim()).charAt(0) == '\"' && piece.charAt(piece.length() - 1) == '\"') {
                piece = piece.substring(1, piece.length() - 1);
                piece = piece.trim();
            }
            pieces[pi++] = piece;
            i2 = j + 1;
        }
        return pieces;
    }

    public class ChecksumException
    extends Exception {
        private static final long serialVersionUID = 7022699404764909882L;

        public ChecksumException(String text) {
            super(text);
        }
    }
}

