/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.cytoscape.util.swing.TextIcon;

public final class IconUtil {
    public static final Color NDEX_LOGO_COLOR = new Color(0, 124, 205);
    public static final Color ICON_COLOR_1 = UIManager.getColor("CyColor.complement(-2)");
    public static final Color ICON_COLOR_2 = UIManager.getColor("CyColor.complement(+1)");
    public static final String ICON_NDEX_LOGO = "\ue906";
    public static final String ICON_NDEX_CLOUD = "\ue903";
    public static final String ICON_NDEX_CLOUD_ARROW_DOWN = "\ue905";
    public static final String ICON_NDEX_CLOUD_ARROW_UP = "\ue904";
    public static final String ICON_NDEX_ACCOUNT = "\ue900";
    public static final String ICON_NDEX_ACCOUNT_MINUS = "\ue901";
    public static final String ICON_NDEX_ACCOUNT_PLUS = "\ue902";
    public static final String[] LAYERED_OPEN_ICON = new String[]{"\ue903", "\ue905"};
    public static final String[] LAYERED_SAVE_ICON = new String[]{"\ue903", "\ue904"};
    public static final Color[] LAYERED_OPEN_SAVE_COLORS = new Color[]{ICON_COLOR_2, Color.WHITE};
    private static Font appFont;

    static {
        try {
            appFont = Font.createFont(0, IconUtil.class.getResourceAsStream("/fonts/cyndex.ttf"));
        }
        catch (FontFormatException e) {
            throw new RuntimeException();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static Font getAppFont(float size) {
        return appFont.deriveFont(size);
    }

    private IconUtil() {
    }

    public static Icon getNdexIcon() {
        Font iconFont = IconUtil.getAppFont(32.0f);
        return new TextIcon(ICON_NDEX_LOGO, iconFont, ICON_COLOR_1, 32, 32);
    }
}

