/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.util;

import org.cytoscape.ci.CIErrorFactory;
import org.cytoscape.ci.CIExceptionFactory;
import org.cytoscape.ci.CIResponseFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class CIServiceManager {
    private final ServiceTracker ciResponseFactoryTracker;
    private final ServiceTracker ciErrorFactoryTracker;
    private final ServiceTracker ciExceptionFactoryTracker;
    private CIResponseFactory ciResponseFactory;
    private CIExceptionFactory ciExceptionFactory;
    private CIErrorFactory ciErrorFactory;

    public CIServiceManager(BundleContext bc) throws InvalidSyntaxException {
        this.ciResponseFactoryTracker = new ServiceTracker(bc, bc.createFilter("(objectClass=org.cytoscape.ci.CIResponseFactory)"), null);
        this.ciResponseFactoryTracker.open();
        this.ciExceptionFactoryTracker = new ServiceTracker(bc, bc.createFilter("(objectClass=org.cytoscape.ci.CIExceptionFactory)"), null);
        this.ciExceptionFactoryTracker.open();
        this.ciErrorFactoryTracker = new ServiceTracker(bc, bc.createFilter("(objectClass=org.cytoscape.ci.CIErrorFactory)"), null);
        this.ciErrorFactoryTracker.open();
    }

    public CIResponseFactory getCIResponseFactory() {
        if (this.ciResponseFactory == null) {
            this.ciResponseFactory = (CIResponseFactory)this.ciResponseFactoryTracker.getService();
        }
        return this.ciResponseFactory;
    }

    public CIErrorFactory getCIErrorFactory() {
        if (this.ciErrorFactory == null) {
            this.ciErrorFactory = (CIErrorFactory)this.ciErrorFactoryTracker.getService();
        }
        return this.ciErrorFactory;
    }

    public CIExceptionFactory getCIExceptionFactory() {
        if (this.ciExceptionFactory == null) {
            this.ciExceptionFactory = (CIExceptionFactory)this.ciExceptionFactoryTracker.getService();
        }
        return this.ciExceptionFactory;
    }

    public void close() {
        if (this.ciResponseFactoryTracker != null) {
            this.ciResponseFactoryTracker.close();
        }
        if (this.ciExceptionFactoryTracker != null) {
            this.ciExceptionFactoryTracker.close();
        }
        if (this.ciErrorFactoryTracker != null) {
            this.ciErrorFactoryTracker.close();
        }
    }
}

