/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.ui.swing.SignInAdvancedDialog;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.util.swing.IconManager;

public class SignInDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    final int ICON_FONT_SIZE = 22;
    private String serverURL = "www.ndexbio.org";
    private JButton cancel;
    private JLabel forgotPasswordLabel;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel needAccountLabel;
    private JLabel needAccountLabel1;
    private JPasswordField password;
    private JButton save;
    private JLabel signUpLabel;
    private JButton updateSettingsButton;
    private JTextField username;

    public SignInDialog(JDialog parent) {
        super((Dialog)parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.save);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.username = new JTextField();
        this.jLabel6 = new JLabel();
        this.password = new JPasswordField();
        this.forgotPasswordLabel = new JLabel();
        this.needAccountLabel = new JLabel();
        this.signUpLabel = new JLabel();
        this.updateSettingsButton = new JButton("\uf013");
        this.save = new JButton();
        this.cancel = new JButton();
        this.needAccountLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel2.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel2.setText("NDEx Sign in");
        this.jLabel5.setText("Username:");
        this.jLabel6.setText("Password:");
        this.forgotPasswordLabel.setForeground(new Color(51, 122, 183));
        this.forgotPasswordLabel.setText("Click here to reset it in browser");
        this.forgotPasswordLabel.setCursor(new Cursor(12));
        this.forgotPasswordLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SignInDialog.this.forgotPasswordLabelMouseClicked(evt);
            }
        });
        this.needAccountLabel.setText("Need an account?");
        this.signUpLabel.setForeground(new Color(51, 122, 183));
        this.signUpLabel.setText("Click here to Sign Up in browser");
        this.signUpLabel.setCursor(new Cursor(12));
        this.signUpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SignInDialog.this.signUpLabelMouseClicked(evt);
            }
        });
        this.updateSettingsButton.setFont(CyServiceModule.getService(IconManager.class).getIconFont(17.0f));
        this.updateSettingsButton.setToolTipText("Additional sign-in options");
        this.updateSettingsButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.updateSettingsButton.setBorderPainted(false);
        this.updateSettingsButton.setContentAreaFilled(false);
        this.updateSettingsButton.setFocusPainted(false);
        this.updateSettingsButton.setMaximumSize(new Dimension(32, 32));
        this.updateSettingsButton.setMinimumSize(new Dimension(24, 24));
        this.updateSettingsButton.setPreferredSize(new Dimension(24, 24));
        this.updateSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignInDialog.this.updateSettingsButtonActionPerformed(evt);
            }
        });
        this.save.setText("Sign in");
        this.save.setMaximumSize(new Dimension(63, 24));
        this.save.setMinimumSize(new Dimension(63, 24));
        this.save.setPreferredSize(new Dimension(63, 24));
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignInDialog.this.saveActionPerformed(evt);
            }
        });
        this.cancel.setText("Cancel");
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignInDialog.this.cancelActionPerformed(evt);
            }
        };
        this.cancel.addActionListener(cancelListener);
        this.cancel.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.needAccountLabel1.setText("Forgot password?");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.username).addComponent(this.password))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.updateSettingsButton, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.save, -2, 83, -2).addGap(18, 18, 18).addComponent(this.cancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.needAccountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.signUpLabel)).addGroup(layout.createSequentialGroup().addComponent(this.needAccountLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.forgotPasswordLabel, -1, -1, Short.MAX_VALUE))).addGap(0, 61, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.username, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.password, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.forgotPasswordLabel).addComponent(this.needAccountLabel1)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancel, -2, 24, -2).addComponent(this.save, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.needAccountLabel).addComponent(this.signUpLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.updateSettingsButton, -2, -1, -2))).addGap(15, 15, 15)));
        this.pack();
    }

    private void updateSettingsButtonActionPerformed(ActionEvent evt) {
        SignInAdvancedDialog advancedSettingsDialog = new SignInAdvancedDialog(this, this.serverURL);
        advancedSettingsDialog.setLocationRelativeTo(this);
        advancedSettingsDialog.setVisible(true);
        if (advancedSettingsDialog.isChanged()) {
            this.serverURL = advancedSettingsDialog.getNewServerURL();
        }
        advancedSettingsDialog.dispose();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.signInToServer();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void forgotPasswordLabelMouseClicked(MouseEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(String.valueOf(ServerManager.addHttpsProtocol(this.serverURL)) + "/viewer/recoverPassword"));
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(SignInDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void signUpLabelMouseClicked(MouseEvent evt) {
        try {
            Desktop.getDesktop().browse(new URI(String.valueOf(ServerManager.addHttpsProtocol(this.serverURL)) + "/viewer/signup"));
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(SignInDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void signInToServer() {
        String usernameText = this.username.getText();
        String passwordText = new String(this.password.getPassword());
        String userName = usernameText.trim();
        if (userName.length() == 0) {
            JOptionPane.showMessageDialog(this, "Username can't be blank.", "Error", 0);
            return;
        }
        if (passwordText.length() == 0) {
            JOptionPane.showMessageDialog(this, "Password can't be blank.", "Error", 0);
            return;
        }
        try {
            ServerManager.INSTANCE.addServer(userName, passwordText, this.serverURL);
            this.setVisible(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error Adding Server", 0);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SignInDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SignInDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SignInDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SignInDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SignInDialog dialog = new SignInDialog(new JDialog());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

