/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.ui.swing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.cytoscape.cyndex2.external.SaveParameters;
import org.cytoscape.cyndex2.internal.CyActivator;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.SimpleNetworkSummary;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExSaveParameters;
import org.cytoscape.cyndex2.internal.rest.response.SummaryResponse;
import org.cytoscape.cyndex2.internal.ui.swing.ModalProgressHelper;
import org.cytoscape.cyndex2.internal.ui.swing.SignInButtonHelper;
import org.cytoscape.cyndex2.internal.ui.swing.SignInDialog;
import org.cytoscape.cyndex2.internal.ui.swing.UpdateSettingsDialog;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.cyndex2.internal.util.UpdateUtil;
import org.cytoscape.cyndex2.internal.util.UserAgentUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.IconManager;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;

public class ExportNetworkDialog
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    final SaveParameters saveParameters;
    private boolean isUUIDChanged = false;
    final int ICON_FONT_SIZE = 22;
    private JTextField authorField;
    private JButton cancelButton;
    private JTextArea descriptionTextArea;
    private JTextField diseaseField;
    private JButton exportButton;
    private JButton jButton1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane3;
    private JTextField nameField;
    private JTextField organismField;
    private JButton profileButton;
    private JTextField referenceField;
    private JTextField rightsHolderField;
    private JTextField tissueField;
    private JCheckBox updateCheckbox;
    private JLabel updateErrorLabel;
    private JButton updateSettingsButton;
    private JTextField versionField;

    public ExportNetworkDialog(Frame parent, SaveParameters saveParameters) {
        super(parent, true);
        this.saveParameters = saveParameters;
        ServerManager.INSTANCE.addPropertyChangeListener(this);
        this.initComponents();
        this.prepComponents();
    }

    private SimpleNetworkSummary getCurrentCollectionSummary(SummaryResponse summaryResponse) {
        return summaryResponse.currentRootNetwork;
    }

    private SimpleNetworkSummary getCurrentNetworkSummary(SummaryResponse summaryResponse) {
        for (SimpleNetworkSummary networkSummary : summaryResponse.members) {
            if (networkSummary.suid.longValue() != summaryResponse.currentNetworkSuid.longValue()) continue;
            return networkSummary;
        }
        return null;
    }

    private boolean isCollection() {
        return "collection".equals(this.saveParameters.saveType);
    }

    private String getEquivalentKey(String key, Map<String, Object> map) {
        String upperCaseKey = key.toUpperCase();
        String equivalentKey = map.keySet().stream().reduce(null, (retVal, current) -> retVal != null ? retVal : (current.toUpperCase().equals(upperCaseKey) ? current : null));
        return equivalentKey;
    }

    private void prepComponents() {
        boolean isCollection = this.isCollection();
        this.setModal(true);
        this.rootPane.setDefaultButton(this.exportButton);
        String REST_URI = "http://localhost:" + CyActivator.getCyRESTPort() + "/cyndex2/v1/networks/" + this.saveParameters.suid;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        URI uri = URI.create(REST_URI);
        HttpGet get = new HttpGet(uri.toString());
        get.setHeader("Content-type", "application/json");
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(result, JsonNode.class);
            SummaryResponse summaryResponse = (SummaryResponse)objectMapper.treeToValue((TreeNode)jsonNode.get("data"), SummaryResponse.class);
            this.updateUpdateButton();
            this.authorField.setEnabled(!isCollection);
            this.organismField.setEnabled(!isCollection);
            this.diseaseField.setEnabled(!isCollection);
            this.tissueField.setEnabled(!isCollection);
            this.rightsHolderField.setEnabled(!isCollection);
            this.versionField.setEnabled(!isCollection);
            this.referenceField.setEnabled(!isCollection);
            this.descriptionTextArea.setEnabled(!isCollection);
            SimpleNetworkSummary summary = isCollection ? this.getCurrentCollectionSummary(summaryResponse) : this.getCurrentNetworkSummary(summaryResponse);
            String authorKey = this.getEquivalentKey("author", summary.props);
            String organismKey = this.getEquivalentKey("organism", summary.props);
            String diseaseKey = this.getEquivalentKey("disease", summary.props);
            String tissueKey = this.getEquivalentKey("tissue", summary.props);
            String rightsHolderKey = this.getEquivalentKey("rightsHolder", summary.props);
            String versionKey = this.getEquivalentKey("version", summary.props);
            String referenceKey = this.getEquivalentKey("reference", summary.props);
            String descriptionKey = this.getEquivalentKey("description", summary.props);
            this.nameField.setText(summary.name);
            this.authorField.setText(isCollection ? "" : (authorKey != null ? summary.props.get(authorKey).toString() : ""));
            this.organismField.setText(isCollection ? "" : (organismKey != null ? summary.props.get(organismKey).toString() : ""));
            this.diseaseField.setText(isCollection ? "" : (diseaseKey != null ? summary.props.get(diseaseKey).toString() : ""));
            this.tissueField.setText(isCollection ? "" : (tissueKey != null ? summary.props.get(tissueKey).toString() : ""));
            this.rightsHolderField.setText(isCollection ? "" : (rightsHolderKey != null ? summary.props.get(rightsHolderKey).toString() : ""));
            this.versionField.setText(isCollection ? "" : (versionKey != null ? summary.props.get(versionKey).toString() : ""));
            this.referenceField.setText(isCollection ? "" : (referenceKey != null ? summary.props.get(referenceKey).toString() : ""));
            this.descriptionTextArea.setText(isCollection ? "" : (descriptionKey != null ? summary.props.get(descriptionKey).toString() : ""));
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel();
        this.organismField = new JTextField();
        this.authorField = new JTextField();
        this.diseaseField = new JTextField();
        this.nameField = new JTextField();
        this.rightsHolderField = new JTextField();
        this.jLabel7 = new JLabel();
        this.exportButton = new JButton();
        this.jLabel11 = new JLabel();
        this.tissueField = new JTextField();
        this.updateCheckbox = new JCheckBox();
        this.cancelButton = new JButton();
        this.profileButton = SignInButtonHelper.createSignInButton(this);
        this.jLabel9 = new JLabel();
        this.referenceField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel13 = new JLabel();
        this.versionField = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.updateErrorLabel = new JLabel();
        this.updateSettingsButton = new JButton("\uf013");
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Network to NDEx");
        this.organismField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportNetworkDialog.this.organismFieldActionPerformed(evt);
            }
        });
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportNetworkDialog.this.nameFieldActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Organism");
        this.exportButton.setText("Export " + (this.isCollection() ? "Collection" : "Network") + " to NDEx");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportNetworkDialog.this.exportButtonActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Version");
        this.updateCheckbox.setText("Update Existing Network");
        this.updateCheckbox.setHorizontalAlignment(0);
        this.updateCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportNetworkDialog.this.updateCheckboxActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportNetworkDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.profileButton.setText(SignInButtonHelper.getSignInText());
        this.profileButton.setMaximumSize(new Dimension(200, 30));
        this.profileButton.setMinimumSize(new Dimension(48, 30));
        this.jLabel9.setText("Tissue");
        this.referenceField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportNetworkDialog.this.referenceFieldActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Author");
        this.jLabel13.setText("Description");
        this.jLabel8.setText("Disease");
        this.jLabel5.setText("Name:");
        this.jLabel12.setText("Reference");
        this.jLabel10.setText("Rights Holder");
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(5);
        this.jScrollPane3.setViewportView(this.descriptionTextArea);
        this.updateErrorLabel.setHorizontalAlignment(0);
        this.updateErrorLabel.setText("Unable to update network.");
        this.updateErrorLabel.setEnabled(false);
        this.updateErrorLabel.setFocusable(false);
        this.updateSettingsButton.setFont(CyServiceModule.getService(IconManager.class).getIconFont(17.0f));
        this.updateSettingsButton.setToolTipText("Update options...");
        this.updateSettingsButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.updateSettingsButton.setBorderPainted(false);
        this.updateSettingsButton.setContentAreaFilled(false);
        this.updateSettingsButton.setFocusPainted(false);
        this.updateSettingsButton.setMaximumSize(new Dimension(32, 32));
        this.updateSettingsButton.setMinimumSize(new Dimension(24, 24));
        this.updateSettingsButton.setPreferredSize(new Dimension(24, 24));
        this.updateSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportNetworkDialog.this.updateSettingsButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6).addComponent(this.jLabel5).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.organismField).addComponent(this.diseaseField).addComponent(this.tissueField).addComponent(this.rightsHolderField).addComponent(this.versionField).addComponent(this.referenceField, GroupLayout.Alignment.TRAILING).addComponent(this.nameField).addComponent(this.authorField).addComponent(this.jScrollPane3, -1, 447, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exportButton)).addComponent(this.updateErrorLabel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.profileButton, -2, -1, -2))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGap(180, 180, 180).addComponent(this.updateCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateSettingsButton, -2, 24, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.profileButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.authorField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.organismField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.diseaseField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.tissueField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.rightsHolderField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.versionField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.referenceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 14, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jScrollPane3, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.updateCheckbox).addComponent(this.updateSettingsButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateErrorLabel, -1, 17, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.exportButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void updateSettingsButtonActionPerformed(ActionEvent evt) {
        CyNetwork network = UpdateUtil.getNetworkForSUID(this.saveParameters.suid, this.saveParameters.saveType.equals("collection"));
        UpdateSettingsDialog updateSettingsDialog = new UpdateSettingsDialog(this, network, ServerManager.INSTANCE.getSelectedServer(), !this.updateCheckbox.isEnabled());
        updateSettingsDialog.setLocationRelativeTo(this);
        updateSettingsDialog.setVisible(true);
        UUID newUUID = updateSettingsDialog.getNewUUID();
        this.isUUIDChanged |= updateSettingsDialog.isChanged();
        updateSettingsDialog.dispose();
        if (newUUID != null) {
            this.updateUpdateButton();
            this.updateCheckbox.setSelected(true);
        }
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
    }

    private void organismFieldActionPerformed(ActionEvent evt) {
    }

    private void referenceFieldActionPerformed(ActionEvent evt) {
    }

    private void prepareToWriteNetworkToCXStream(CyNetwork cyNetwork, PipedOutputStream out, boolean isUpdate) {
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        Server server = ServerManager.INSTANCE.getServer();
        if (server.getUsername() == null) {
            SignInDialog signInDialog = new SignInDialog(null);
            signInDialog.setLocationRelativeTo(this);
            signInDialog.setVisible(true);
            Server selectedServer = ServerManager.INSTANCE.getServer();
            if (selectedServer.getUsername() == null || selectedServer.getUsername().isEmpty()) {
                signInDialog.dispose();
                return;
            }
            signInDialog.dispose();
        }
        Container container = this.getParent();
        ModalProgressHelper.runWorker(this, "Exporting to NDEx", () -> {
            Server selectedServer = ServerManager.INSTANCE.getSelectedServer();
            boolean update = this.updateCheckbox.isEnabled() && this.updateCheckbox.isSelected();
            String REST_URI = "http://localhost:" + CyActivator.getCyRESTPort() + "/cyndex2/v1/networks/" + this.saveParameters.suid;
            CloseableHttpClient httpClient = HttpClients.createDefault();
            URI uri = URI.create(REST_URI);
            HttpPut request = update ? new HttpPut(uri.toString()) : new HttpPost(uri.toString());
            request.setHeader("Content-type", "application/json");
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("name", this.nameField.getText());
            metadata.put("author", this.authorField.getText());
            metadata.put("organism", this.organismField.getText());
            metadata.put("disease", this.diseaseField.getText());
            metadata.put("tissue", this.tissueField.getText());
            metadata.put("rightsHolder", this.rightsHolderField.getText());
            metadata.put("version", this.versionField.getText());
            metadata.put("reference", this.referenceField.getText());
            metadata.put("description", this.descriptionTextArea.getText());
            System.out.println("REST_URI: " + REST_URI);
            System.out.println("url " + selectedServer.getUrl());
            NDExSaveParameters saveParams = new NDExSaveParameters(selectedServer.getUsername(), selectedServer.getPassword(), selectedServer.getUrl(), metadata, false);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                request.setEntity((HttpEntity)new StringEntity(objectMapper.writeValueAsString((Object)saveParams)));
                HttpResponse response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonNode jsonNode = (JsonNode)objectMapper.readValue(result, JsonNode.class);
                    String uuid = jsonNode.get("data").get("uuid").asText();
                    JOptionPane.showMessageDialog(container, "Export to NDEx successful.\n\nUUID: " + uuid, "Export Complete", -1);
                } else {
                    String result = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonNode jsonNode = (JsonNode)objectMapper.readValue(result, JsonNode.class);
                    String errorMessage = jsonNode.get("errors").get(0).get("message").asText();
                    JOptionPane.showMessageDialog(container, "Export to NDEx failed with the following message:\n\n" + errorMessage, "Export Error", 0);
                }
            }
            catch (JsonProcessingException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return 1;
        });
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void updateCheckboxActionPerformed(ActionEvent evt) {
        System.out.println("update checked.");
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.isVisible()) {
            this.profileButton.setText(SignInButtonHelper.getSignInText());
            this.updateUpdateButton();
        }
    }

    private static String htmlWrap(String input) {
        return "<html><body><div style=\"width: 186px; word-wrap: break-word; text-align: center\">" + input + "</div></body></html>";
    }

    private void updateUpdateButton() {
        boolean updatePossible;
        Server selectedServer = ServerManager.INSTANCE.getServer();
        if (selectedServer == Server.DEFAULT_SERVER) {
            updatePossible = false;
            this.updateErrorLabel.setText("Update not possible. Please sign in to a valid NDEx account");
        } else {
            try {
                System.out.println("Checking if update is possible for suid: " + this.saveParameters.suid);
                NdexRestClient nc = new NdexRestClient(selectedServer.getUsername(), selectedServer.getPassword(), selectedServer.getUrl(), UserAgentUtil.getUserAgent());
                NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(nc);
                updatePossible = UpdateUtil.updateIsPossibleHelper(this.saveParameters.suid, this.saveParameters.saveType.equals("collection"), nc, mal, !this.isUUIDChanged) != null;
                this.updateErrorLabel.setText(updatePossible ? "Update the existing network in NDEx" : "Update not possible, unknown error.");
            }
            catch (Exception e) {
                System.out.println("Update is not possible: " + e.getMessage());
                this.updateErrorLabel.setText(ExportNetworkDialog.htmlWrap(e.getMessage()));
                e.printStackTrace();
                updatePossible = false;
            }
        }
        this.updateCheckbox.setSelected(false);
        this.updateCheckbox.setEnabled(updatePossible);
        this.updateErrorLabel.setVisible(!updatePossible);
    }
}

