/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import org.cytoscape.application.swing.search.NetworkSearchTaskFactory;
import org.cytoscape.cyndex2.internal.rest.parameter.LoadParameters;
import org.cytoscape.cyndex2.internal.task.OpenDialogTaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;

public class OpenBrowseTaskFactory
extends OpenDialogTaskFactory
implements NetworkSearchTaskFactory {
    private static final String ID = "cyndex2";
    private static final String NAME = "NDEx - Network Search";
    private final Icon icon;
    private static Entry entry;

    public OpenBrowseTaskFactory(Icon icon) {
        super("choose");
        this.icon = icon;
    }

    public static Entry getEntry() {
        if (entry == null) {
            entry = new Entry();
        }
        return entry;
    }

    public String getName() {
        return NAME;
    }

    public JComponent getQueryComponent() {
        return OpenBrowseTaskFactory.getEntry();
    }

    public String getQuery() {
        return OpenBrowseTaskFactory.getEntry().getQuery();
    }

    @Override
    public TaskIterator createTaskIterator() {
        LoadParameters.INSTANCE.searchTerm = this.getQuery();
        LoadParameters.INSTANCE.userNetworksOnly = false;
        return super.createTaskIterator();
    }

    public String getDescription() {
        return "<html>The Network Data Exchange (NDEx) is a cloud-based database <br />and software infrastructure to store, share and publish <br />biological network knowledge. NDEx provides a REST API and<br />several client libraries are available for programmatic <br />access. NDEx users can request DOIs for their networks and <br />rely on full integration with Cytoscape. <br />NDEx is also available as an installation bundle for users <br />working with networks in a confidential environment. <br />For more information on NDEx and its Advanced Search <br />capabilities, please visit our website.</html>";
    }

    public URL getWebsite() {
        try {
            return new URL("http://www.home.ndexbio.org/finding-and-querying-networks/#searchexamples");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getId() {
        return ID;
    }

    public JComponent getOptionsComponent() {
        return null;
    }

    public TaskObserver getTaskObserver() {
        return null;
    }

    public static class Entry
    extends JTextField {
        private static final long serialVersionUID = -5305178656253939245L;
        private final Font SEARCH_TEXT_FONT = new Font("SansSerif", 0, 12);
        private final Color TEXT_COLOR = Color.decode("#444444");
        private static final String SEARCH_TEXT = "Enter search terms for NDEx...";
        private boolean disabled = false;
        private JToolTip tip;

        public Entry() {
            super(SEARCH_TEXT);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setForeground(Color.GRAY);
            this.setToolTipText("");
            this.tip = new JToolTip();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    super.keyTyped(e);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        this.fireSearchRequested();
                    } else {
                        this.firePropertyChange("query", null, null);
                    }
                    super.keyPressed(e);
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (this.getForeground() == Color.GRAY) {
                        this.setText("");
                        this.setForeground(Color.BLACK);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (this.getText().isEmpty()) {
                        this.setForeground(Color.GRAY);
                        this.setText(Entry.SEARCH_TEXT);
                    }
                }
            });
        }

        public String getQuery() {
            return this.getForeground() == Color.GRAY ? "" : this.getText();
        }

        public void setDisabled(String message) {
            this.setEnabled(false);
            this.setText("Unable to start CyNDEx2");
            this.tip = new JToolTip();
            this.tip.add(new JLabel(message));
            this.setForeground(Color.GRAY);
            this.disabled = true;
            this.firePropertyChange("query", null, null);
        }

        @Override
        public JToolTip createToolTip() {
            ToolTipManager.sharedInstance().setDismissDelay(7000);
            if (this.disabled) {
                this.tip.setComponent(this);
                this.tip.setLayout(new BorderLayout());
                this.tip.add((Component)new JLabel("Likely caused by a failure to update CyNDEx2 or an issue with existing JXBrowser instances."), "Center");
                return this.tip;
            }
            Dimension size = new Dimension(220, 280);
            JEditorPane pane = new JEditorPane();
            pane.setBackground(Color.white);
            pane.setEditable(false);
            pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            pane.setFont(this.SEARCH_TEXT_FONT);
            pane.setForeground(this.TEXT_COLOR);
            pane.setContentType("text/html");
            String help = "<h3>NDEx Database Search</h3><p>Enter search query for NDEx database. You can use</p><br/>  - Gene names<br/>  - Gene IDs<br/>  - Keywords<br/>  - Shared Network URL<br/>  - etc.<br/><p>If you want to browse the database, simply send empty query. For more details, please visit <i>www.ndexbio.org</i></p>";
            pane.setText("<h3>NDEx Database Search</h3><p>Enter search query for NDEx database. You can use</p><br/>  - Gene names<br/>  - Gene IDs<br/>  - Keywords<br/>  - Shared Network URL<br/>  - etc.<br/><p>If you want to browse the database, simply send empty query. For more details, please visit <i>www.ndexbio.org</i></p>");
            pane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.tip.setPreferredSize(size);
            this.tip.setSize(size);
            this.tip.setComponent(this);
            this.tip.setLayout(new BorderLayout());
            this.tip.add((Component)pane, "Center");
            this.tip.setVisible(true);
            return this.tip;
        }

        private void fireSearchRequested() {
            this.firePropertyChange("searchRequested", null, null);
        }
    }
}

