/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.rest.endpoints.impl;

import java.io.InputStream;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.SwingUtilities;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.ci.CIWrapping;
import org.cytoscape.ci.model.CIError;
import org.cytoscape.cyndex2.internal.CxTaskFactoryManager;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.NdexClient;
import org.cytoscape.cyndex2.internal.rest.SimpleNetworkSummary;
import org.cytoscape.cyndex2.internal.rest.endpoints.NdexNetworkResource;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorBuilder;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorType;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExBasicSaveParameters;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExImportParameters;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExSaveParameters;
import org.cytoscape.cyndex2.internal.rest.response.NdexBaseResponse;
import org.cytoscape.cyndex2.internal.rest.response.SummaryResponse;
import org.cytoscape.cyndex2.internal.task.NDExExportTaskFactory;
import org.cytoscape.cyndex2.internal.task.NDExImportTaskFactory;
import org.cytoscape.cyndex2.internal.util.CIServiceManager;
import org.cytoscape.cyndex2.internal.util.NDExNetworkManager;
import org.cytoscape.cyndex2.internal.util.Server;
import org.cytoscape.cyndex2.internal.util.ServerManager;
import org.cytoscape.cyndex2.internal.util.UpdateUtil;
import org.cytoscape.cyndex2.internal.util.UserAgentUtil;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.util.ListSingleSelection;
import org.ndexbio.model.object.network.NetworkSummary;
import org.ndexbio.rest.client.NdexRestClient;
import org.ndexbio.rest.client.NdexRestClientModelAccessLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdexNetworkResourceImpl
implements NdexNetworkResource {
    private static final Logger logger = LoggerFactory.getLogger(NdexNetworkResourceImpl.class);
    private final NdexClient client;
    private final CyNetworkManager networkManager;
    private final CyApplicationManager appManager;
    private final CIServiceManager ciServiceManager;
    private final ErrorBuilder errorBuilder;

    public NdexNetworkResourceImpl(NdexClient client, CyApplicationManager appManager, CyNetworkManager networkManager, CIServiceManager ciServiceTracker) {
        this.client = client;
        this.ciServiceManager = ciServiceTracker;
        this.errorBuilder = CyServiceModule.INSTANCE.getErrorBuilder();
        this.networkManager = networkManager;
        this.appManager = appManager;
    }

    private CyNetwork getCurrentNetwork() {
        CyNetwork network = this.appManager.getCurrentNetwork();
        if (network == null) {
            String message = "Current network does not exist. Select a network or specify an SUID.";
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, "Current network does not exist. Select a network or specify an SUID.", ErrorType.INVALID_PARAMETERS);
        }
        return network;
    }

    private CyNetwork getNetworkFromSUID(Long suid) throws WebApplicationException {
        if (suid == null) {
            logger.error("SUID is missing");
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, "SUID is not specified.", ErrorType.INVALID_PARAMETERS);
        }
        CyNetwork network = this.networkManager.getNetwork(suid.longValue());
        if (network == null) {
            for (CyNetwork net : this.networkManager.getNetworkSet()) {
                CyRootNetwork root = ((CySubNetwork)net).getRootNetwork();
                Long rootSUID = root.getSUID();
                if (rootSUID.compareTo(suid) != 0) continue;
                network = root;
                break;
            }
        }
        if (network == null) {
            String message = "Network/Collection with SUID " + String.valueOf(suid) + " does not exist.";
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, message, ErrorType.INVALID_PARAMETERS);
        }
        return network;
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CINdexBaseResponse createNetworkFromNdex(NDExImportParameters params) {
        try {
            NDExImportTaskFactory importFactory = this.getNDExImportTaskFactory(params);
            TaskIterator iter = importFactory.createTaskIterator();
            this.execute(iter);
            NdexBaseResponse response = new NdexBaseResponse(importFactory.getSUID(), params.uuid);
            return (NdexNetworkResource.CINdexBaseResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)response, NdexNetworkResource.CINdexBaseResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON. Error: " + e.getMessage();
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    public NDExExportTaskFactory getNDExExportTaskFactory(NDExBasicSaveParameters params, boolean isUpdate) {
        return new NDExExportTaskFactory(params, isUpdate);
    }

    public NDExImportTaskFactory getNDExImportTaskFactory(NDExImportParameters params) {
        return new NDExImportTaskFactory(params);
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CINdexBaseResponse saveNetworkToNdex(Long suid, NDExSaveParameters params) {
        try {
            NDExExportTaskFactory exportFactory = this.getNDExExportTaskFactory(params, false);
            CyNetwork network = this.getNetworkFromSUID(suid);
            TaskIterator iter = exportFactory.createTaskIterator(network);
            this.execute(iter);
            UUID newUUID = exportFactory.getUUID();
            if (newUUID == null) {
                String message = "No UUID returned from NDEx API.";
                logger.error("No UUID returned from NDEx API.");
                throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "No UUID returned from NDEx API.", ErrorType.INTERNAL);
            }
            NdexBaseResponse response = new NdexBaseResponse(suid, newUUID.toString());
            return (NdexNetworkResource.CINdexBaseResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)response, NdexNetworkResource.CINdexBaseResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e2) {
            String message = "Could not create wrapped CI JSON response. Error: " + e2.getMessage();
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CINdexBaseResponse saveCurrentNetworkToNdex(NDExSaveParameters params) {
        CyNetwork network = this.getCurrentNetwork();
        return this.saveNetworkToNdex(network.getSUID(), params);
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CISummaryResponse getCurrentNetworkSummary() {
        CyNetwork network = this.getCurrentNetwork();
        CyRootNetwork root = ((CySubNetwork)network).getRootNetwork();
        SummaryResponse response = NdexNetworkResourceImpl.buildSummary(root, (CySubNetwork)network);
        try {
            return (NdexNetworkResource.CISummaryResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)response, NdexNetworkResource.CISummaryResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON. Error: " + e.getMessage();
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CISummaryResponse getNetworkSummary(Long suid) {
        CyNetwork network = this.networkManager.getNetwork(suid.longValue());
        CyRootNetwork rootNetwork = null;
        if (network == null) {
            for (CyNetwork net : this.networkManager.getNetworkSet()) {
                CyRootNetwork root;
                Long rootSUID;
                if (!(net instanceof CySubNetwork) || (rootSUID = (root = ((CySubNetwork)net).getRootNetwork()).getSUID()).compareTo(suid) != 0) continue;
                rootNetwork = root;
                break;
            }
        } else {
            rootNetwork = ((CySubNetwork)network).getRootNetwork();
        }
        if (rootNetwork == null) {
            String message = "Cannot find collection/network with SUID " + String.valueOf(suid) + ".";
            logger.error(message);
            CIError ciError = this.ciServiceManager.getCIErrorFactory().getCIError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "urn:cytoscape:ci:ndex:v1:errors:1", message, URI.create("file:///log"));
            throw this.ciServiceManager.getCIExceptionFactory().getCIException(Response.Status.BAD_REQUEST.getStatusCode(), new CIError[]{ciError});
        }
        SummaryResponse response = NdexNetworkResourceImpl.buildSummary(rootNetwork, (CySubNetwork)network);
        try {
            return (NdexNetworkResource.CISummaryResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)response, NdexNetworkResource.CISummaryResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON. Error: " + e.getMessage();
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    private static final SummaryResponse buildSummary(CyRootNetwork root, CySubNetwork network) {
        SummaryResponse summary = new SummaryResponse();
        SimpleNetworkSummary rootSummary = NdexNetworkResourceImpl.buildNetworkSummary((CyNetwork)root, root.getDefaultNetworkTable(), root.getSUID());
        if (network != null) {
            summary.currentNetworkSuid = network.getSUID();
        }
        summary.currentRootNetwork = rootSummary;
        ArrayList<SimpleNetworkSummary> members = new ArrayList<SimpleNetworkSummary>();
        root.getSubNetworkList().stream().forEach(subnet -> {
            boolean bl = members.add(NdexNetworkResourceImpl.buildNetworkSummary((CyNetwork)subnet, subnet.getDefaultNetworkTable(), subnet.getSUID()));
        });
        summary.members = members;
        return summary;
    }

    private static final SimpleNetworkSummary buildNetworkSummary(CyNetwork network, CyTable table, Long networkSuid) {
        SimpleNetworkSummary summary = new SimpleNetworkSummary();
        CyRow row = table.getRow((Object)networkSuid);
        summary.suid = network.getSUID();
        summary.name = (String)network.getTable(CyNetwork.class, "LOCAL_ATTRS").getRow((Object)network.getSUID()).get("name", String.class);
        UUID uuid = NDExNetworkManager.getUUID(network);
        if (uuid != null) {
            summary.uuid = uuid.toString();
        }
        Collection columns = table.getColumns();
        HashMap<String, Object> props = new HashMap<String, Object>();
        columns.stream().forEach(col -> {
            Object object = props.put(col.getName(), row.get(col.getName(), col.getType()));
        });
        summary.props = props;
        return summary;
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CINdexBaseResponse updateNetworkInNdex(Long suid, NDExBasicSaveParameters params) {
        UUID uuid;
        CyNetwork network = this.getNetworkFromSUID(suid);
        try {
            NdexRestClient nc = new NdexRestClient(params.username, params.password, params.serverUrl, UserAgentUtil.getUserAgent());
            NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(nc);
            uuid = UpdateUtil.updateIsPossibleHelper(suid, network instanceof CyRootNetwork, nc, mal);
        }
        catch (Exception e) {
            String message = "Unable to update network in NDEx. " + e.getMessage() + " Try saving as a new network.";
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.BAD_REQUEST, message, ErrorType.INVALID_PARAMETERS);
        }
        boolean success = this.updateLoop(network, params);
        if (!success) {
            String message = "Could not update existing NDEx entry.  NDEx server did not accept your request.";
            logger.error("Could not update existing NDEx entry.  NDEx server did not accept your request.");
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Could not update existing NDEx entry.  NDEx server did not accept your request.", ErrorType.INTERNAL);
        }
        String uuidStr = uuid.toString();
        NdexBaseResponse response = new NdexBaseResponse(suid, uuidStr);
        try {
            return (NdexNetworkResource.CINdexBaseResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)response, NdexNetworkResource.CINdexBaseResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON. Error: " + e.getMessage();
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    private final boolean updateExistingNetwork(CyNetwork network, NDExBasicSaveParameters params) {
        NDExExportTaskFactory exportFactory = this.getNDExExportTaskFactory(params, true);
        TaskIterator iter = exportFactory.createTaskIterator(network);
        this.execute(iter);
        return true;
    }

    private boolean updateLoop(CyNetwork network, NDExBasicSaveParameters params) {
        int retryCount = 0;
        boolean success = false;
        while (retryCount <= 3) {
            try {
                success = this.updateExistingNetwork(network, params);
                if (!success) continue;
                return true;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            finally {
                ++retryCount;
            }
        }
        return false;
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CINdexBaseResponse updateNdexUUIDOfNetwork(Long suid, Map<String, String> rec) {
        Timestamp serverTimestamp;
        UUID verifiedUUID = null;
        String uuidString = rec.get("uuid");
        UUID potentialUUID = UUID.fromString(uuidString);
        CyNetwork network = UpdateUtil.getNetworkForSUID(suid, false);
        Server selectedServer = ServerManager.INSTANCE.getSelectedServer();
        try {
            NdexRestClient nc = new NdexRestClient(selectedServer.getUsername(), selectedServer.getPassword(), selectedServer.getUrl(), UserAgentUtil.getUserAgent());
            NdexRestClientModelAccessLayer mal = new NdexRestClientModelAccessLayer(nc);
            verifiedUUID = UpdateUtil.updateIsPossible(network, potentialUUID, nc, mal, false);
            NetworkSummary ns = mal.getNetworkSummaryById(verifiedUUID);
            serverTimestamp = ns.getModificationTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Error validating UUID: " + e.getMessage(), ErrorType.INTERNAL);
        }
        if (verifiedUUID != null && serverTimestamp != null) {
            NDExNetworkManager.saveUUID(network, verifiedUUID, serverTimestamp);
        }
        NdexBaseResponse response = new NdexBaseResponse(suid, uuidString);
        try {
            return (NdexNetworkResource.CINdexBaseResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)response, NdexNetworkResource.CINdexBaseResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON. Error: " + e.getMessage();
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CINdexBaseResponse updateCurrentNetworkInNdex(NDExBasicSaveParameters params) {
        CyNetwork network = this.getCurrentNetwork();
        return this.updateNetworkInNdex(network.getSUID(), params);
    }

    @Override
    @CIWrapping
    public NdexNetworkResource.CINdexBaseResponse createNetworkFromCx(InputStream in) {
        InputStreamTaskFactory taskFactory = CxTaskFactoryManager.INSTANCE.getCxReaderFactory();
        TaskIterator iter = taskFactory.createTaskIterator(in, null);
        AbstractCyNetworkReader reader = (AbstractCyNetworkReader)iter.next();
        reader.setRootNetworkList(new ListSingleSelection((Object[])new String[0]));
        iter.append((Task)reader);
        this.execute(iter);
        CyNetwork[] cyNetworkArray = reader.getNetworks();
        int n = cyNetworkArray.length;
        int n2 = 0;
        while (n2 < n) {
            CyNetwork net = cyNetworkArray[n2];
            this.networkManager.addNetwork(net);
            ++n2;
        }
        reader.buildCyNetworkView(reader.getNetworks()[0]);
        Long suid = reader.getNetworks()[0].getSUID();
        NdexBaseResponse response = new NdexBaseResponse(suid, "");
        try {
            return (NdexNetworkResource.CINdexBaseResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)response, NdexNetworkResource.CINdexBaseResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON. Error: " + e.getMessage();
            logger.error(message);
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, message, ErrorType.INTERNAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(final TaskIterator iter) {
        final DialogTaskManager tm = CyServiceModule.getService(DialogTaskManager.class);
        final Object lock = new Object();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                tm.execute(iter, new TaskObserver(){

                    public void taskFinished(ObservableTask task) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void allFinished(FinishStatus finishStatus) {
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                });
            }
        };
        try {
            SwingUtilities.invokeAndWait(runner);
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

