/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.rest.endpoints.impl;

import javax.ws.rs.core.Response;
import org.cytoscape.ci.CIWrapping;
import org.cytoscape.cyndex2.internal.CyServiceModule;
import org.cytoscape.cyndex2.internal.rest.endpoints.NdexBaseResource;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorBuilder;
import org.cytoscape.cyndex2.internal.rest.errors.ErrorType;
import org.cytoscape.cyndex2.internal.rest.response.AppInfoResponse;
import org.cytoscape.cyndex2.internal.util.CIServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdexBaseResourceImpl
implements NdexBaseResource {
    private static final Logger logger = LoggerFactory.getLogger(NdexBaseResourceImpl.class);
    private static final AppInfoResponse SUMMARY = new AppInfoResponse();
    private final ErrorBuilder errorBuilder;
    private final CIServiceManager ciServiceManager;

    static {
        NdexBaseResourceImpl.SUMMARY.apiVersion = "1";
        NdexBaseResourceImpl.SUMMARY.appName = "CyNDEx-2";
        NdexBaseResourceImpl.SUMMARY.description = "NDEx client for Cytoscape. This app supports NDEx REST API V2 only.";
    }

    public NdexBaseResourceImpl(String bundleVersion, CIServiceManager ciServiceManager) {
        NdexBaseResourceImpl.SUMMARY.appVersion = bundleVersion;
        this.ciServiceManager = ciServiceManager;
        this.errorBuilder = CyServiceModule.INSTANCE.getErrorBuilder();
    }

    @Override
    @CIWrapping
    public NdexBaseResource.CIAppInfoResponse getAppInfo() {
        try {
            return (NdexBaseResource.CIAppInfoResponse)this.ciServiceManager.getCIResponseFactory().getCIResponse((Object)SUMMARY, NdexBaseResource.CIAppInfoResponse.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = "Could not create wrapped CI JSON.";
            logger.error("Could not create wrapped CI JSON.");
            throw this.errorBuilder.buildException(Response.Status.INTERNAL_SERVER_ERROR, "Could not create wrapped CI JSON.", ErrorType.INTERNAL);
        }
    }
}

