/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.cyndex2.internal.rest.endpoints;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.cytoscape.ci.model.CIResponse;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExBasicSaveParameters;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExImportParameters;
import org.cytoscape.cyndex2.internal.rest.parameter.NDExSaveParameters;
import org.cytoscape.cyndex2.internal.rest.response.NdexBaseResponse;
import org.cytoscape.cyndex2.internal.rest.response.SummaryResponse;

@Api(tags={"Apps: CyNDEx-2"})
@Path(value="/cyndex2/v1/networks")
public interface NdexNetworkResource {
    @ApiOperation(value="Get the summary of current network and collection.", notes="Returns summary of collection contains current network.", response=CISummaryResponse.class)
    @GET
    @Path(value="/current")
    @Produces(value={"application/json"})
    public CISummaryResponse getCurrentNetworkSummary();

    @ApiOperation(value="Get the summary of specified network and collection.", notes="Returns summary of collection containing the specified network.", response=CISummaryResponse.class)
    @GET
    @Path(value="/{suid}")
    @Produces(value={"application/json"})
    public CISummaryResponse getNetworkSummary(@ApiParam(value="Cytoscape Collection/Subnetwork SUID") @PathParam(value="suid") Long var1);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/")
    @ApiOperation(value="Import network from NDEx", notes="Import network(s) from NDEx.", response=CINdexBaseResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CINdexBaseResponse.class)})
    public CINdexBaseResponse createNetworkFromNdex(@ApiParam(value="Raw CX object to be imported to Cytoscape.", required=true) NDExImportParameters var1);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/cx")
    @ApiOperation(value="Import network(s) from cyRestClient", notes="Import network(s) from cyRestClient.", response=CINdexBaseResponse.class)
    @ApiImplicitParams(value={@ApiImplicitParam(value="CX network", paramType="body", required=true)})
    public CINdexBaseResponse createNetworkFromCx(@ApiParam(hidden=true) InputStream var1);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/current")
    @ApiOperation(value="Save current network/collection to NDEx", notes="Save current network/collection to NDEx", response=CINdexBaseResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Current network does not exist", response=CINdexBaseResponse.class)})
    public CINdexBaseResponse saveCurrentNetworkToNdex(@ApiParam(value="Properties required to save current network to NDEx.", required=true) NDExSaveParameters var1);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{suid}")
    @ApiOperation(value="Save network/collection to NDEx", notes="Save a network/collection to NDEx", response=CINdexBaseResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CINdexBaseResponse.class)})
    public CINdexBaseResponse saveNetworkToNdex(@ApiParam(value="Cytoscape Collection/Subnetwork SUID") @PathParam(value="suid") Long var1, @ApiParam(value="Properties required to save network to NDEx.", required=true) NDExSaveParameters var2);

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{suid}")
    @ApiOperation(value="Update an existing NDEx network entry", notes="Update an NDEx network.", response=CINdexBaseResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CINdexBaseResponse.class)})
    public CINdexBaseResponse updateNetworkInNdex(@ApiParam(value="Cytoscape Collection/Subnetwork SUID") @PathParam(value="suid") Long var1, @ApiParam(value="Properties required to update a network record in NDEx.", required=true) NDExBasicSaveParameters var2);

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{suid}/NDEXUUID")
    @ApiOperation(value="Set the associcated NDEx UUID in the specified network", notes="Set NDEx UUID in a network.", response=CINdexBaseResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CINdexBaseResponse.class)})
    public CINdexBaseResponse updateNdexUUIDOfNetwork(@ApiParam(value="Cytoscape Collection/Subnetwork SUID") @PathParam(value="suid") Long var1, @ApiParam(value="Properties required to update a network record in NDEx.", required=true) Map<String, String> var2);

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/current")
    @ApiOperation(value="Update current Cytoscape network record in NDEx", notes="Update current network's record in NDEx", response=CINdexBaseResponse.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Network does not exist", response=CINdexBaseResponse.class)})
    public CINdexBaseResponse updateCurrentNetworkInNdex(@ApiParam(value="Properties required to update a network record in NDEx.", required=true) NDExBasicSaveParameters var1);

    @ApiModel(value="NDEx Base Response", parent=CIResponse.class)
    public static class CINdexBaseResponse
    extends CIResponse<NdexBaseResponse> {
    }

    @ApiModel(value="Summary Response", parent=CIResponse.class)
    public static class CISummaryResponse
    extends CIResponse<SummaryResponse> {
    }
}

