/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.work;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.internal.ModelUtil;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterImpl;
import org.cytoscape.filter.internal.work.DefaultBuffer;
import org.cytoscape.filter.internal.work.DiscreteProgressMonitor;
import org.cytoscape.filter.internal.work.ProgressMonitor;
import org.cytoscape.filter.internal.work.SubProgressMonitor;
import org.cytoscape.filter.internal.work.TransformerBuffer;
import org.cytoscape.filter.internal.work.TransformerExecutionStrategy;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.ElementTransformer;
import org.cytoscape.filter.model.ElementTransformerFactory;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.FilterFactory;
import org.cytoscape.filter.model.HolisticTransformer;
import org.cytoscape.filter.model.HolisticTransformerFactory;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.model.TransformerSink;
import org.cytoscape.filter.model.TransformerSource;

public class TransformerManagerImpl
implements TransformerManager {
    Map<Class<?>, TransformerSource<?, ?>> sources;
    Map<String, FilterFactory<?, ?>> filterFactories;
    Map<String, ElementTransformerFactory<?, ?>> elementTransformerFactories;
    Map<String, HolisticTransformerFactory<?, ?>> holisticTransformerFactories;
    TransformerExecutionStrategy bufferedStrategy;
    TransformerExecutionStrategy unbufferedStrategy;

    public TransformerManagerImpl() {
        int maximumThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        this.bufferedStrategy = new BufferedExecutionStrategy();
        this.unbufferedStrategy = new UnbufferedExecutionStrategy(maximumThreads);
        this.sources = new ConcurrentHashMap(16, 0.75f, 2);
        this.filterFactories = new ConcurrentHashMap(16, 0.75f, 2);
        this.elementTransformerFactories = new ConcurrentHashMap(16, 0.75f, 2);
        this.holisticTransformerFactories = new ConcurrentHashMap(16, 0.75f, 2);
    }

    public <C, E> void execute(C context, TransformerSource<C, E> source, List<Transformer<C, E>> transformers, TransformerSink<E> sink) {
        this.execute(context, source, transformers, sink, ProgressMonitor.nullMonitor());
    }

    public <C, E> void execute(C context, TransformerSource<C, E> source, List<Transformer<C, E>> transformers, TransformerSink<E> sink, ProgressMonitor monitor) {
        TransformerExecutionStrategy strategy = this.getOptimalStrategy(transformers);
        strategy.execute(context, transformers, source, sink, monitor);
    }

    public <C, E> void execute(C context, List<Transformer<C, E>> transformers, TransformerSink<E> sink) {
        if (transformers.size() == 0) {
            return;
        }
        Class contextType = transformers.get(0).getContextType();
        TransformerSource<C, E> source = this.getTransformerSource(contextType);
        this.execute(context, source, transformers, sink);
    }

    public <C, E> void execute(C context, Transformer<C, E> transformer, TransformerSink<E> sink) {
        Class contextType = transformer.getContextType();
        TransformerSource<C, E> source = this.getTransformerSource(contextType);
        if (transformer instanceof Filter) {
            this.applyFilter(context, source, (Filter)transformer, sink, ProgressMonitor.nullMonitor());
        } else if (transformer instanceof HolisticTransformer) {
            ((HolisticTransformer)transformer).apply(context, source, sink);
        } else if (transformer instanceof ElementTransformer) {
            TransformerBuffer<C, E> sinkBuffer = this.createTransformerBuffer(source, context);
            this.applyElementTransformer(context, source, (ElementTransformer)transformer, sinkBuffer, ProgressMonitor.nullMonitor());
            for (Object element : sinkBuffer.getElementList(context)) {
                sink.collect(element);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public <C, E> TransformerExecutionStrategy getOptimalStrategy(List<Transformer<C, E>> transformers) {
        for (Transformer<C, E> transformer : transformers) {
            if (!(transformer instanceof ElementTransformer) && !(transformer instanceof HolisticTransformer)) continue;
            return this.bufferedStrategy;
        }
        return this.unbufferedStrategy;
    }

    <C, E> void applyElementTransformer(C context, TransformerSource<C, E> source, ElementTransformer<C, E> transformer, TransformerSink<E> sink, ProgressMonitor monitor) {
        List elements = source.getElementList(context);
        DiscreteProgressMonitor dpm = new DiscreteProgressMonitor(monitor);
        dpm.setTotalWork(elements.size());
        for (Object element : elements) {
            if (dpm.isCancelled()) {
                return;
            }
            transformer.apply(context, element, sink);
            dpm.addWork(1);
        }
        dpm.done();
    }

    <C, E> void applyFilter(C context, TransformerSource<C, E> source, Filter<C, E> filter, TransformerSink<E> sink, ProgressMonitor monitor) {
        List elements = source.getElementList(context);
        DiscreteProgressMonitor dpm = new DiscreteProgressMonitor(monitor);
        dpm.setTotalWork(elements.size());
        for (Object element : source.getElementList(context)) {
            if (dpm.isCancelled()) {
                return;
            }
            if (filter.accepts(context, element)) {
                sink.collect(element);
            }
            dpm.addWork(1);
        }
        dpm.done();
    }

    <C, E> TransformerBuffer<C, E> createTransformerBuffer(TransformerSource<C, E> source, C context) {
        Class contextType = source.getContextType();
        return new DefaultBuffer(contextType, source.getElementType(), source.getElementCount(context), 4);
    }

    public void registerTransformerSource(TransformerSource<?, ?> source, Map<String, String> properties) {
        this.sources.put(source.getContextType(), source);
    }

    public void unregisterTransformerSource(TransformerSource<?, ?> source, Map<String, String> properties) {
        this.sources.remove(source.getContextType());
    }

    public <C, E> TransformerSource<C, E> getTransformerSource(Class<C> contextType) {
        TransformerSource<?, ?> source = this.sources.get(contextType);
        if (source == null) {
            throw new IllegalArgumentException("No TransformerSource registered for " + contextType);
        }
        return source;
    }

    public <C, E> CompositeFilter<C, E> createCompositeFilter(Class<C> contextType, Class<E> elementType) {
        return new CompositeFilterImpl<C, E>(contextType, elementType);
    }

    public void registerFilterFactory(FilterFactory<?, ?> factory, Map<String, String> properties) {
        this.filterFactories.put(factory.getId(), factory);
    }

    public void unregisterFilterFactory(FilterFactory<?, ?> factory, Map<String, String> properties) {
        this.filterFactories.remove(factory.getId());
    }

    public void registerElementTransformerFactory(ElementTransformerFactory<?, ?> factory, Map<String, String> properties) {
        this.elementTransformerFactories.put(factory.getId(), factory);
    }

    public void unregisterElementTransformerFactory(ElementTransformerFactory<?, ?> factory, Map<String, String> properties) {
        this.elementTransformerFactories.remove(factory.getId());
    }

    public void registerHolisticTransformerFactory(HolisticTransformerFactory<?, ?> factory, Map<String, String> properties) {
        this.holisticTransformerFactories.put(factory.getId(), factory);
    }

    public void unregisterHolisticTransformerFactory(HolisticTransformerFactory<?, ?> factory, Map<String, String> properties) {
        this.holisticTransformerFactories.remove(factory.getId());
    }

    public <C, E> Transformer<C, E> createTransformer(String id) {
        Filter<C, E> transformer = this.createFilter(id);
        if (transformer != null) {
            return transformer;
        }
        transformer = this.createElementTransformer(id);
        if (transformer != null) {
            return transformer;
        }
        return this.createHolisticTransformer(id);
    }

    public <C, E> NamedTransformer<C, E> createNamedTransformer(String name, List<Transformer<C, E>> transformers) {
        return ModelUtil.createNamedTransformer(name, transformers.toArray(new Transformer[0]));
    }

    <C, E> Filter<C, E> createFilter(String id) {
        FilterFactory<?, ?> factory = this.filterFactories.get(id);
        if (factory == null) {
            return null;
        }
        return factory.createFilter();
    }

    <C, E> ElementTransformer<C, E> createElementTransformer(String id) {
        ElementTransformerFactory<?, ?> factory = this.elementTransformerFactories.get(id);
        if (factory == null) {
            return null;
        }
        return factory.createElementTransformer();
    }

    <C, E> HolisticTransformer<C, E> createHolisticTransformer(String id) {
        HolisticTransformerFactory<?, ?> factory = this.holisticTransformerFactories.get(id);
        if (factory == null) {
            return null;
        }
        return factory.createHolisticTransformer();
    }

    <E> Iterator<E>[] partitionIterators(final List<E> elements, final int totalWorkers) {
        final int total = elements.size();
        Iterator[] iterators = new Iterator[totalWorkers];
        for (int i = 0; i < totalWorkers; ++i) {
            final int offset = i;
            iterators[i] = new Iterator<E>(){
                int index;

                @Override
                public boolean hasNext() {
                    return this.index * totalWorkers + offset < total;
                }

                @Override
                public E next() {
                    int elementIndex = this.index * totalWorkers + offset;
                    if (elementIndex < total) {
                        ++this.index;
                        return elements.get(elementIndex);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return iterators;
    }

    class UnbufferedExecutionStrategy
    implements TransformerExecutionStrategy {
        private static final int PARALLEL_THRESHOLD = 100000;
        int maximumThreads;
        BlockingQueue<Runnable> workQueue;
        ThreadPoolExecutor executor;

        public UnbufferedExecutionStrategy(int maximumThreads) {
            this.maximumThreads = maximumThreads;
            this.workQueue = new ArrayBlockingQueue<Runnable>(maximumThreads);
            this.executor = new ThreadPoolExecutor(maximumThreads, maximumThreads, Integer.MAX_VALUE, TimeUnit.SECONDS, this.workQueue, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }

        @Override
        public <C, E> void execute(final C context, final List<Transformer<C, E>> transformers, TransformerSource<C, E> source, final TransformerSink<E> sink, ProgressMonitor monitor) {
            if (source.getElementCount(context) < 100000) {
                this.execute(context, transformers, source.getElementList(context).iterator(), sink);
                return;
            }
            Iterator<E>[] iterators = TransformerManagerImpl.this.partitionIterators(source.getElementList(context), this.maximumThreads);
            int totalWorkers = iterators.length;
            final Semaphore finished = new Semaphore(-totalWorkers + 1);
            for (int i = 0; i < totalWorkers; ++i) {
                final Iterator iterator = iterators[i];
                Runnable worker = new Runnable(){

                    @Override
                    public void run() {
                        UnbufferedExecutionStrategy.this.execute(context, transformers, iterator, sink);
                        finished.release();
                    }
                };
                this.executor.execute(worker);
            }
            try {
                finished.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private <C, E> void execute(C context, List<Transformer<C, E>> transformers, Iterator<E> iterator, TransformerSink<E> sink) {
            block0: while (iterator.hasNext()) {
                E element = iterator.next();
                for (Transformer<C, E> transformer : transformers) {
                    if (!(transformer instanceof Filter)) {
                        throw new UnsupportedOperationException();
                    }
                    if (((Filter)transformer).accepts(context, element)) continue;
                    continue block0;
                }
                sink.collect(element);
            }
        }
    }

    class BufferedExecutionStrategy
    implements TransformerExecutionStrategy {
        BufferedExecutionStrategy() {
        }

        @Override
        public <C, E> void execute(C context, List<Transformer<C, E>> transformers, TransformerSource<C, E> source, TransformerSink<E> sink, ProgressMonitor monitor) {
            TransformerBuffer<C, E> sourceBuffer = TransformerManagerImpl.this.createTransformerBuffer(source, context);
            TransformerBuffer<C, E> sinkBuffer = TransformerManagerImpl.this.createTransformerBuffer(source, context);
            TransformerSource<C, E> currentSource = source;
            int n = transformers.size();
            double stepSize = 1.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                double stepStart = (double)i * stepSize;
                double stepEnd = stepStart + stepSize;
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, stepStart, stepEnd);
                subMonitor.start();
                Transformer<C, E> transformer = transformers.get(i);
                if (transformer instanceof Filter) {
                    TransformerManagerImpl.this.applyFilter(context, currentSource, (Filter)transformer, sinkBuffer, subMonitor);
                } else if (transformer instanceof ElementTransformer) {
                    TransformerManagerImpl.this.applyElementTransformer(context, currentSource, (ElementTransformer)transformer, sinkBuffer, subMonitor);
                } else if (transformer instanceof HolisticTransformer) {
                    ((HolisticTransformer)transformer).apply(context, currentSource, sinkBuffer);
                } else {
                    throw new UnsupportedOperationException();
                }
                TransformerBuffer<C, E> tempBuffer = sinkBuffer;
                sinkBuffer = sourceBuffer;
                sourceBuffer = tempBuffer;
                sinkBuffer.clear();
                currentSource = sourceBuffer;
            }
            for (Object element : sourceBuffer.getElementList(context)) {
                sink.collect(element);
            }
        }
    }
}

