/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.view.TransformerViewFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;

public class TransformerViewManager {
    private Map<String, TransformerViewFactory> viewFactories;
    private Map<String, Map<String, String>> viewProperties;
    private List<TransformerViewElement> filterConditionViewElements;
    private List<TransformerViewElement> chainTransformerViewElements;
    private TransformerManager transformerManager;
    private final Object lock = new Object();

    public TransformerViewManager(TransformerManager transformerManager) {
        this.transformerManager = transformerManager;
        this.viewFactories = new ConcurrentHashMap<String, TransformerViewFactory>(16, 0.75f, 2);
        this.viewProperties = new ConcurrentHashMap<String, Map<String, String>>(16, 0.75f, 2);
        this.filterConditionViewElements = new ArrayList<TransformerViewElement>();
        this.chainTransformerViewElements = new ArrayList<TransformerViewElement>();
    }

    public JComponent createView(Transformer<CyNetwork, CyIdentifiable> transformer) {
        TransformerViewFactory viewFactory = this.viewFactories.get(transformer.getId());
        if (viewFactory == null) {
            return null;
        }
        return viewFactory.createView(transformer);
    }

    public String getAddButtonTooltip(Transformer<?, ?> transformer) {
        Map<String, String> props = this.viewProperties.get(transformer.getId());
        if (props == null) {
            return null;
        }
        return props.get("addButtonTooltip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTransformerViewFactory(TransformerViewFactory factory, Map<String, String> properties) {
        Transformer transformer = this.transformerManager.createTransformer(factory.getId());
        if (!transformer.getContextType().equals(CyNetwork.class)) {
            return;
        }
        if (!transformer.getElementType().equals(CyIdentifiable.class)) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List<TransformerViewElement> list = transformer instanceof Filter ? this.filterConditionViewElements : this.chainTransformerViewElements;
            TransformerViewElement element = new TransformerViewElement(transformer.getName(), factory.getId());
            this.viewFactories.put(factory.getId(), factory);
            this.viewProperties.put(factory.getId(), new HashMap<String, String>(properties));
            list.add(element);
            Collections.sort(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTransformerViewFactory(TransformerViewFactory factory, Map<String, String> properties) {
        String id = factory.getId();
        this.viewFactories.remove(id);
        Object object = this.lock;
        synchronized (object) {
            this.removeTransformerViewElement(id, this.filterConditionViewElements);
            this.removeTransformerViewElement(id, this.chainTransformerViewElements);
        }
    }

    void removeTransformerViewElement(String id, List<TransformerViewElement> elements) {
        Iterator<TransformerViewElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            TransformerViewElement element = iterator.next();
            if (!id.equals(element.getId())) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TransformerViewElement> getFilterConditionViewElements() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<TransformerViewElement>(this.filterConditionViewElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TransformerViewElement> getChainTransformerViewElements() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<TransformerViewElement>(this.chainTransformerViewElements);
        }
    }

    class TransformerViewElement
    implements Comparable<TransformerViewElement> {
        private String name;
        private String id;

        public TransformerViewElement(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(TransformerViewElement other) {
            if (this.id == null && other.id == null) {
                return 0;
            }
            if (this.id == null) {
                return -1;
            }
            if (other.id == null) {
                return 1;
            }
            return this.name.compareToIgnoreCase(other.name);
        }
    }
}

