/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import org.cytoscape.filter.internal.view.AbstractComboBoxModel;
import org.cytoscape.filter.internal.view.Matcher;

public class DynamicComboBoxModel<T>
extends AbstractComboBoxModel
implements Iterable<T> {
    List<T> items;
    int selectedIndex;

    public DynamicComboBoxModel(List<T> items) {
        this.items = items;
        this.selectedIndex = items.size() > 0 ? 0 : -1;
    }

    @Override
    public T getElementAt(int index) {
        return this.items.get(index);
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    public T getSelectedItem() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.items.size()) {
            return null;
        }
        return this.items.get(this.selectedIndex);
    }

    @Override
    public void setSelectedItem(Object item) {
        this.selectedIndex = this.items.indexOf(item);
        this.notifyChanged(0, this.items.size() - 1);
    }

    public void add(T item) {
        if (this.selectedIndex == -1) {
            this.selectedIndex = 0;
        }
        int index = this.items.size();
        this.items.add(item);
        this.notifyAdded(index, index);
    }

    public void insert(int index, T item) {
        if (this.selectedIndex == -1) {
            this.selectedIndex = 0;
        }
        this.items.add(index, item);
        this.notifyAdded(index, index);
    }

    public void remove(T item) {
        int index = this.items.indexOf(item);
        this.items.remove(index);
        if (this.items.size() == 0) {
            this.selectedIndex = -1;
        }
        this.notifyRemoved(index, index);
    }

    public T remove(int index) {
        T removed = this.items.remove(index);
        int size = this.items.size();
        if (size == 0) {
            this.selectedIndex = -1;
        }
        if (size == index) {
            this.selectedIndex = size - 1;
        }
        this.notifyRemoved(index, index);
        return removed;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public int find(Matcher<T> matcher) {
        int index = 0;
        for (T item : this) {
            if (matcher.matches(item)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static <T> void select(JComboBox<?> comboBox, int defaultIndex, Matcher<T> matcher) {
        DynamicComboBoxModel model = (DynamicComboBoxModel)comboBox.getModel();
        int index = model.find(matcher);
        if (index == -1) {
            index = defaultIndex;
        }
        comboBox.setSelectedIndex(index);
    }
}

