/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.range;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import org.cytoscape.filter.internal.range.DoubleSliderModel;
import org.cytoscape.filter.internal.range.IntegerSliderModel;
import org.cytoscape.filter.internal.range.RangeChooser;
import org.cytoscape.filter.internal.range.RangeListener;
import org.cytoscape.filter.internal.range.SliderModel;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;

public class RangeChooserController<N extends Number> {
    private final SliderModel<N> sliderModel;
    private final JFormattedTextField.AbstractFormatterFactory formatterFactory;
    private final RangeListener<N> listener;
    private RangeChooser<N> rangeChooser;

    public static RangeChooserController<Integer> forInteger(FilterPanelStyle style, RangeListener<Integer> listener) {
        IntegerSliderModel sliderModel = new IntegerSliderModel();
        JFormattedTextField.AbstractFormatterFactory formatterFactory = ViewUtil.createIntegerFormatterFactory();
        RangeChooserController<Integer> controller = new RangeChooserController<Integer>(sliderModel, formatterFactory, style, listener);
        controller.reset(0, 0, 0, 0);
        return controller;
    }

    public static RangeChooserController<Double> forDouble(FilterPanelStyle style, RangeListener<Double> listener) {
        DoubleSliderModel sliderModel = new DoubleSliderModel();
        ViewUtil.NumberFormatterFactory formatterFactory = ViewUtil.createNumberFormatterFactory();
        RangeChooserController<Double> controller = new RangeChooserController<Double>(sliderModel, formatterFactory, style, listener);
        controller.reset(0.0, 0.0, 0.0, 0.0);
        return controller;
    }

    private RangeChooserController(SliderModel<N> sliderModel, JFormattedTextField.AbstractFormatterFactory formatterFactory, FilterPanelStyle style, RangeListener<N> listener) {
        this.sliderModel = sliderModel;
        this.formatterFactory = formatterFactory;
        this.listener = listener;
        this.rangeChooser = new RangeChooser(style, this);
    }

    public SliderModel<N> getSliderModel() {
        return this.sliderModel;
    }

    public JFormattedTextField.AbstractFormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public RangeChooser<N> getRangeChooser() {
        return this.rangeChooser;
    }

    public void setInteractive(boolean isInteractive) {
        if (this.rangeChooser != null) {
            this.rangeChooser.setInteractive(isInteractive);
        }
    }

    public void reset(N low, N high, N min, N max) {
        this.rangeChooser.removeListeners();
        this.setSliderValues(low, high, min, max);
        this.rangeChooser.getLowField().setValue(low);
        this.rangeChooser.getHighField().setValue(high);
        this.rangeChooser.addListeners(this);
    }

    private void setSliderValues(N low, N high, N min, N max) {
        if (((Comparable)low).compareTo(min) < 0) {
            low = min;
        }
        if (((Comparable)high).compareTo(max) > 0) {
            high = max;
        }
        this.sliderModel.setValues(low, high, min, max);
    }

    private N clampByFormat(JFormattedTextField.AbstractFormatter format, N value) {
        if (format == null) {
            return value;
        }
        if (value == null) {
            return null;
        }
        try {
            return (N)((Number)format.stringToValue(format.valueToString(value)));
        }
        catch (ParseException e) {
            return null;
        }
    }

    void sliderChanged() {
        this.rangeChooser.removeListeners();
        JFormattedTextField minimumField = this.rangeChooser.getLowField();
        JFormattedTextField maximumField = this.rangeChooser.getHighField();
        N low = this.clampByFormat(minimumField.getFormatterFactory().getFormatter(minimumField), this.sliderModel.getLow());
        N high = this.clampByFormat(maximumField.getFormatterFactory().getFormatter(maximumField), this.sliderModel.getHigh());
        minimumField.setValue(low);
        maximumField.setValue(high);
        this.handleRangeChanged(low, high);
        this.rangeChooser.addListeners(this);
    }

    void textFieldChanged() {
        this.rangeChooser.removeListeners();
        N low = this.getLow();
        N high = this.getHigh();
        this.setSliderValues(low, high, this.sliderModel.getMin(), this.sliderModel.getMax());
        this.handleRangeChanged(low, high);
        this.rangeChooser.addListeners(this);
    }

    private void handleRangeChanged(N low, N high) {
        if (this.listener != null) {
            this.listener.rangeChanged(low, high);
        }
    }

    public N getLow() {
        return (N)((Number)this.rangeChooser.getLowField().getValue());
    }

    public N getHigh() {
        return (N)((Number)this.rangeChooser.getHighField().getValue());
    }
}

